/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Iterables;
import io.druid.java.util.common.io.Closer;
import io.druid.segment.data.ColumnarMultiInts;
import io.druid.segment.data.CompressedVSizeColumnarMultiIntsSupplier;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.VSizeColumnarInts;
import io.druid.segment.data.WritableSupplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressedVSizeColumnarMultiIntsSupplierTest {
    private Closer closer;
    protected List<int[]> vals;
    protected WritableSupplier<ColumnarMultiInts> indexedSupplier;

    @Before
    public void setUpSimple() {
        this.closer = Closer.create();
        this.vals = Arrays.asList(new int[1], {1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
        this.indexedSupplier = CompressedVSizeColumnarMultiIntsSupplier.fromIterable((Iterable)Iterables.transform(this.vals, input -> VSizeColumnarInts.fromArray((int[])input, (int)20)), (int)20, (ByteOrder)ByteOrder.nativeOrder(), (CompressionStrategy)CompressionStrategy.LZ4, (Closer)this.closer);
    }

    @After
    public void teardown() throws IOException {
        this.indexedSupplier = null;
        this.vals = null;
        this.closer.close();
    }

    @Test
    public void testSanity() throws Exception {
        this.assertSame(this.vals, (ColumnarMultiInts)this.indexedSupplier.get());
    }

    @Test
    public void testSerde() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.indexedSupplier.writeTo(Channels.newChannel(baos), null);
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)this.indexedSupplier.getSerializedSize(), (long)bytes.length);
        WritableSupplier<ColumnarMultiInts> deserializedIndexed = this.fromByteBuffer(ByteBuffer.wrap(bytes));
        this.assertSame(this.vals, (ColumnarMultiInts)deserializedIndexed.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetInvalidElementInRow() {
        ((ColumnarMultiInts)this.indexedSupplier.get()).get(3).get(15);
    }

    @Test
    public void testIterators() {
        Iterator iterator = ((ColumnarMultiInts)this.indexedSupplier.get()).iterator();
        int row = 0;
        while (iterator.hasNext()) {
            int[] ints = this.vals.get(row);
            IndexedInts vSizeIndexedInts = (IndexedInts)iterator.next();
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            for (int i = 0; i < vSizeIndexedInts.size(); ++i) {
                Assert.assertEquals((long)ints[i], (long)vSizeIndexedInts.get(i));
            }
            ++row;
        }
    }

    private void assertSame(List<int[]> someInts, ColumnarMultiInts indexed) {
        Assert.assertEquals((long)someInts.size(), (long)indexed.size());
        for (int i = 0; i < indexed.size(); ++i) {
            int[] ints = someInts.get(i);
            IndexedInts vSizeIndexedInts = indexed.get(i);
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            for (int j = 0; j < ints.length; ++j) {
                Assert.assertEquals((long)ints[j], (long)vSizeIndexedInts.get(j));
            }
        }
    }

    protected WritableSupplier<ColumnarMultiInts> fromByteBuffer(ByteBuffer buffer) {
        return CompressedVSizeColumnarMultiIntsSupplier.fromByteBuffer((ByteBuffer)buffer, (ByteOrder)ByteOrder.nativeOrder());
    }
}

