/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.Result;
import io.druid.query.expression.TestExprMacroTable;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import io.druid.timeline.DataSegment;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;

public class TestHelper {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    public static IndexMergerV9 getTestIndexMergerV9(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        return new IndexMergerV9(JSON_MAPPER, TestHelper.getTestIndexIO(segmentWriteOutMediumFactory), segmentWriteOutMediumFactory);
    }

    public static IndexIO getTestIndexIO(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        return new IndexIO(JSON_MAPPER, segmentWriteOutMediumFactory, new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
    }

    public static ObjectMapper makeJsonMapper() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(DataSegment.PruneLoadSpecHolder.class, (Object)DataSegment.PruneLoadSpecHolder.DEFAULT));
        return mapper;
    }

    public static ObjectMapper makeSmileMapper() {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper));
        return mapper;
    }

    public static <T> Iterable<T> revert(Iterable<T> input) {
        return Lists.reverse((List)Lists.newArrayList(input));
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Sequence<Result<T>> results) {
        TestHelper.assertResults(expectedResults, Sequences.toList(results, (List)Lists.newArrayList()), "");
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        TestHelper.assertResults(expectedResults, results, "");
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results, String failMsg) {
        TestHelper.assertResults(expectedResults, results, failMsg);
    }

    public static <T> void assertExpectedObjects(Iterable<T> expectedResults, Iterable<T> results, String failMsg) {
        TestHelper.assertObjects(expectedResults, results, failMsg);
    }

    public static <T> void assertExpectedObjects(Iterable<T> expectedResults, Sequence<T> results, String failMsg) {
        TestHelper.assertObjects(expectedResults, Sequences.toList(results, (List)Lists.newArrayList()), failMsg);
    }

    private static <T> void assertResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> actualResults, String failMsg) {
        Iterator<Result<T>> resultsIter = actualResults.iterator();
        Iterator<Result<T>> resultsIter2 = actualResults.iterator();
        Iterator<Result<T>> expectedResultsIter = expectedResults.iterator();
        while (resultsIter.hasNext() && resultsIter2.hasNext() && expectedResultsIter.hasNext()) {
            Result<T> expectedNext = expectedResultsIter.next();
            Result<T> next = resultsIter.next();
            Result<T> next2 = resultsIter2.next();
            if (expectedNext instanceof Row) {
                TestHelper.assertRow(failMsg, (Row)expectedNext, (Row)next);
                TestHelper.assertRow(failMsg, (Row)expectedNext, (Row)next2);
                continue;
            }
            if (expectedNext instanceof Result && expectedNext.getValue() instanceof TimeseriesResultValue) {
                TestHelper.assertTimeseriesResultValue(failMsg, expectedNext, next);
                TestHelper.assertTimeseriesResultValue(StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg}), expectedNext, next2);
                continue;
            }
            if (expectedNext instanceof Result && expectedNext.getValue() instanceof TopNResultValue) {
                TestHelper.assertTopNResultValue(failMsg, expectedNext, next);
                TestHelper.assertTopNResultValue(StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg}), expectedNext, next2);
                continue;
            }
            TestHelper.assertResult(failMsg, expectedNext, next);
            TestHelper.assertResult(StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg}), expectedNext, next2);
        }
        if (resultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter to be exhausted, next element was %s", (Object[])new Object[]{failMsg, resultsIter.next()}));
        }
        if (resultsIter2.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter2 to be exhausted, next element was %s", (Object[])new Object[]{failMsg, resultsIter.next()}));
        }
        if (expectedResultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected expectedResultsIter to be exhausted, next element was %s", (Object[])new Object[]{failMsg, expectedResultsIter.next()}));
        }
    }

    private static <T> void assertObjects(Iterable<T> expectedResults, Iterable<T> actualResults, String msg) {
        Iterator<T> resultsIter = actualResults.iterator();
        Iterator<T> resultsIter2 = actualResults.iterator();
        Iterator<T> expectedResultsIter = expectedResults.iterator();
        int index = 0;
        while (resultsIter.hasNext() && resultsIter2.hasNext() && expectedResultsIter.hasNext()) {
            T expectedNext = expectedResultsIter.next();
            T next = resultsIter.next();
            T next2 = resultsIter2.next();
            String failMsg = msg + "-" + index++;
            String failMsg2 = StringUtils.format((String)"%s: Second iterator bad, multiple calls to iterator() should be safe", (Object[])new Object[]{failMsg});
            if (expectedNext instanceof Row) {
                TestHelper.assertRow(failMsg, (Row)expectedNext, (Row)next);
                TestHelper.assertRow(failMsg2, (Row)expectedNext, (Row)next2);
                continue;
            }
            Assert.assertEquals((String)failMsg, expectedNext, next);
            Assert.assertEquals((String)failMsg2, expectedNext, next2);
        }
        if (resultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter to be exhausted, next element was %s", (Object[])new Object[]{msg, resultsIter.next()}));
        }
        if (resultsIter2.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected resultsIter2 to be exhausted, next element was %s", (Object[])new Object[]{msg, resultsIter.next()}));
        }
        if (expectedResultsIter.hasNext()) {
            Assert.fail((String)StringUtils.format((String)"%s: Expected expectedResultsIter to be exhausted, next element was %s", (Object[])new Object[]{msg, expectedResultsIter.next()}));
        }
    }

    private static void assertResult(String msg, Result<?> expected, Result actual) {
        Assert.assertEquals((String)msg, expected, (Object)actual);
    }

    private static void assertTimeseriesResultValue(String msg, Result expected, Result actual) {
        Assert.assertEquals((String)StringUtils.format((String)"%s: timestamp", (Object[])new Object[]{msg}), (Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        TimeseriesResultValue expectedVal = (TimeseriesResultValue)expected.getValue();
        TimeseriesResultValue actualVal = (TimeseriesResultValue)actual.getValue();
        Map expectedMap = expectedVal.getBaseObject();
        Map actualMap = actualVal.getBaseObject();
        TestHelper.assertRow(msg, (Row)new MapBasedRow(expected.getTimestamp(), expectedMap), (Row)new MapBasedRow(actual.getTimestamp(), actualMap));
    }

    private static void assertTopNResultValue(String msg, Result expected, Result actual) {
        TopNResultValue expectedVal = (TopNResultValue)expected.getValue();
        TopNResultValue actualVal = (TopNResultValue)actual.getValue();
        List listExpectedRows = expectedVal.getValue().stream().map(dimensionAndMetricValueExtractor -> new MapBasedRow(expected.getTimestamp(), dimensionAndMetricValueExtractor.getBaseObject())).collect(Collectors.toList());
        List listActualRows = actualVal.getValue().stream().map(dimensionAndMetricValueExtractor -> new MapBasedRow(actual.getTimestamp(), dimensionAndMetricValueExtractor.getBaseObject())).collect(Collectors.toList());
        Assert.assertEquals((String)"Size of list must match", (long)listExpectedRows.size(), (long)listActualRows.size());
        IntStream.range(0, listExpectedRows.size()).forEach(value -> TestHelper.assertRow(StringUtils.format((String)"%s, on value number [%s]", (Object[])new Object[]{msg, value}), (Row)listExpectedRows.get(value), (Row)listActualRows.get(value)));
    }

    private static void assertRow(String msg, Row expected, Row actual) {
        Assert.assertEquals((String)StringUtils.format((String)"%s: timestamp", (Object[])new Object[]{msg}), (long)expected.getTimestamp().getMillis(), (long)actual.getTimestamp().getMillis());
        Map expectedMap = ((MapBasedRow)expected).getEvent();
        Map actualMap = ((MapBasedRow)actual).getEvent();
        Assert.assertEquals((String)StringUtils.format((String)"%s: map keys", (Object[])new Object[]{msg}), expectedMap.keySet(), actualMap.keySet());
        for (String key : expectedMap.keySet()) {
            Object expectedValue = expectedMap.get(key);
            Object actualValue = actualMap.get(key);
            if (expectedValue instanceof Float || expectedValue instanceof Double) {
                Assert.assertEquals((String)StringUtils.format((String)"%s: key[%s]", (Object[])new Object[]{msg, key}), (double)((Number)expectedValue).doubleValue(), (double)((Number)actualValue).doubleValue(), (double)Math.abs(((Number)expectedValue).doubleValue() * 1.0E-6));
                continue;
            }
            Assert.assertEquals((String)StringUtils.format((String)"%s: key[%s]", (Object[])new Object[]{msg, key}), expectedValue, actualValue);
        }
    }
}

