/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.ImmutableMap;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.Pair;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.segment.DimensionHandler;
import io.druid.segment.IndexSpec;
import io.druid.segment.Rowboat;
import io.druid.segment.SegmentValidationException;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.CompressionStrategy;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.Indexed;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.incremental.IncrementalIndexSchema;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StringDimensionHandlerTest {
    private static final Interval TEST_INTERVAL = Intervals.of((String)"2015-01-01/2015-12-31");
    private static final IndexSpec INDEX_SPEC = new IndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);
    private final List<String> dimensions = Arrays.asList("penguins", "predators");
    @Rule
    public ExpectedException exception = ExpectedException.none();

    private static Pair<IncrementalIndexAdapter, IncrementalIndexAdapter> getAdapters(List<String> dims, Map<String, Object> event1, Map<String, Object> event2) throws Exception {
        IncrementalIndex incrementalIndex1 = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(TEST_INTERVAL.getStartMillis()).withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(dims), null, null)).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build()).setMaxRowCount(1000).buildOnheap();
        IncrementalIndex incrementalIndex2 = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(TEST_INTERVAL.getStartMillis()).withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(dims), null, null)).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build()).setMaxRowCount(1000).buildOnheap();
        incrementalIndex1.add((InputRow)new MapBasedInputRow(TEST_INTERVAL.getStartMillis(), dims, event1));
        incrementalIndex2.add((InputRow)new MapBasedInputRow(TEST_INTERVAL.getStartMillis() + 3L, dims, event2));
        IncrementalIndexAdapter adapter1 = new IncrementalIndexAdapter(TEST_INTERVAL, incrementalIndex1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        IncrementalIndexAdapter adapter2 = new IncrementalIndexAdapter(TEST_INTERVAL, incrementalIndex2, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        return new Pair((Object)adapter1, (Object)adapter2);
    }

    private static void validate(IncrementalIndexAdapter adapter1, IncrementalIndexAdapter adapter2) throws Exception {
        Map handlers = adapter1.getDimensionHandlers();
        Indexed dimNames1 = adapter1.getDimensionNames();
        Indexed dimNames2 = adapter2.getDimensionNames();
        Iterator iterator1 = adapter1.getRows().iterator();
        Iterator iterator2 = adapter2.getRows().iterator();
        while (iterator1.hasNext()) {
            Rowboat r1 = (Rowboat)iterator1.next();
            Rowboat r2 = (Rowboat)iterator2.next();
            Object[] dims1 = r1.getDims();
            Object[] dims2 = r2.getDims();
            for (int i = 0; i < dims1.length; ++i) {
                Object val1 = dims1[i];
                Object val2 = dims2[i];
                String name1 = (String)dimNames1.get(i);
                String name2 = (String)dimNames2.get(i);
                DimensionHandler handler = (DimensionHandler)handlers.get(name1);
                handler.validateSortedEncodedKeyComponents(val1, val2, adapter1.getDimValueLookup(name1), adapter2.getDimValueLookup(name2));
            }
        }
    }

    @Test
    public void testValidateSortedEncodedArrays() throws Exception {
        ImmutableMap event1 = ImmutableMap.of((Object)"penguins", Arrays.asList("adelie", "emperor"), (Object)"predators", Arrays.asList("seal"));
        ImmutableMap event2 = ImmutableMap.of((Object)"penguins", Arrays.asList("adelie", "emperor"), (Object)"predators", Arrays.asList("seal"));
        Pair<IncrementalIndexAdapter, IncrementalIndexAdapter> adapters = StringDimensionHandlerTest.getAdapters(this.dimensions, (Map<String, Object>)event1, (Map<String, Object>)event2);
        IncrementalIndexAdapter adapter1 = (IncrementalIndexAdapter)adapters.lhs;
        IncrementalIndexAdapter adapter2 = (IncrementalIndexAdapter)adapters.rhs;
        StringDimensionHandlerTest.validate(adapter1, adapter2);
    }

    @Test
    public void testValidateSortedDifferentEncodedArrays() throws Exception {
        ImmutableMap event1 = ImmutableMap.of((Object)"penguins", Arrays.asList("adelie", "emperor"), (Object)"predators", Collections.singletonList("seal"));
        ImmutableMap event2 = ImmutableMap.of((Object)"penguins", Arrays.asList("chinstrap", "gentoo"), (Object)"predators", Collections.singletonList("seal"));
        Pair<IncrementalIndexAdapter, IncrementalIndexAdapter> adapters = StringDimensionHandlerTest.getAdapters(this.dimensions, (Map<String, Object>)event1, (Map<String, Object>)event2);
        IncrementalIndexAdapter adapter1 = (IncrementalIndexAdapter)adapters.lhs;
        IncrementalIndexAdapter adapter2 = (IncrementalIndexAdapter)adapters.rhs;
        this.exception.expect(SegmentValidationException.class);
        StringDimensionHandlerTest.validate(adapter1, adapter2);
    }
}

