/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.StupidPool;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestIndex;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TopNQueryRunnerBenchmark
extends AbstractBenchmark {
    private static final String marketDimension = "market";
    private static final String segmentId = "testSegment";
    private static final HashMap<String, Object> context = new HashMap();
    private static final TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
    private static final Map<TestCases, QueryRunner> testCaseMap = Maps.newHashMap();

    @BeforeClass
    public static void setUp() throws Exception {
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory((NonBlockingPool)new StupidPool("TopNQueryRunnerFactory-directBufferPool", (Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(2000);
            }
        }), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        testCaseMap.put(TestCases.rtIndex, QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), segmentId), null));
        testCaseMap.put(TestCases.mMappedTestIndex, QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(segmentId, TestIndex.getMMappedTestIndex()), null));
        testCaseMap.put(TestCases.mergedRealtimeIndex, QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new QueryableIndexSegment(segmentId, TestIndex.mergedRealtimeIndex()), null));
    }

    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testmMapped() {
        testCaseMap.get((Object)TestCases.mMappedTestIndex).run(QueryPlus.wrap((Query)query), context);
    }

    @Ignore
    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testrtIndex() {
        testCaseMap.get((Object)TestCases.rtIndex).run(QueryPlus.wrap((Query)query), context);
    }

    @Ignore
    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testMerged() {
        testCaseMap.get((Object)TestCases.mergedRealtimeIndex).run(QueryPlus.wrap((Query)query), context);
    }

    @Ignore
    @BenchmarkOptions(warmupRounds=10000, benchmarkRounds=10000)
    @Test
    public void testOffHeap() {
        testCaseMap.get((Object)TestCases.rtIndexOffheap).run(QueryPlus.wrap((Query)query), context);
    }

    public static enum TestCases {
        rtIndex,
        mMappedTestIndex,
        mergedRealtimeIndex,
        rtIndexOffheap;

    }
}

