/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.QueryMetrics;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.IdLookup;
import io.druid.segment.Metadata;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TopNMetricSpecOptimizationsTest {
    @Test
    public void testShouldOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-31T00:00:00Z").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        StorageAdapter adapter = this.makeFakeStorageAdapter("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality);
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, cardinality, adapter);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(threshold), (Object)thePair.rhs);
    }

    @Test
    public void testAlsoShouldOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-30T01:00:00Z").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        StorageAdapter adapter = this.makeFakeStorageAdapter("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality);
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, cardinality, adapter);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(threshold), (Object)thePair.rhs);
    }

    @Test
    public void testShouldNotOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-30T01:00:00Z").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        StorageAdapter adapter = this.makeFakeStorageAdapter("2018-05-30T00:00:00Z", "2018-05-31T00:00:00Z", cardinality);
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, cardinality, adapter);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(cardinality), (Object)thePair.rhs);
    }

    @Test
    public void testAlsoShouldNotOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").filters("quality", "entertainment").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-31T00:00:00Z").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        StorageAdapter adapter = this.makeFakeStorageAdapter("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality);
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, cardinality, adapter);
        arrayProviderToTest.ignoreAfterThreshold();
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(cardinality), (Object)thePair.rhs);
    }

    @Test
    public void testAgainShouldNotOptimizeLexicographic() {
        int cardinality = 1234;
        int threshold = 4;
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("market").metric("index").threshold(threshold).intervals("2018-05-30T00:00:00Z/2018-05-31T00:00:00Z").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant)).build();
        StorageAdapter adapter = this.makeFakeStorageAdapter("2018-05-30T00:00:00Z", "2018-05-30T01:00:00Z", cardinality);
        DimensionSelector dimSelector = this.makeFakeDimSelector(cardinality);
        BaseTopNAlgorithm.AggregatorArrayProvider arrayProviderToTest = new BaseTopNAlgorithm.AggregatorArrayProvider(dimSelector, query, cardinality, adapter);
        Pair thePair = arrayProviderToTest.computeStartEnd(cardinality);
        Assert.assertEquals((Object)new Integer(0), (Object)thePair.lhs);
        Assert.assertEquals((Object)new Integer(cardinality), (Object)thePair.rhs);
    }

    private StorageAdapter makeFakeStorageAdapter(final String start, final String end, final int cardinality) {
        StorageAdapter adapter = new StorageAdapter(){

            public Interval getInterval() {
                return Intervals.of((String)(start + "/" + end));
            }

            public int getDimensionCardinality(String column) {
                return cardinality;
            }

            public DateTime getMinTime() {
                return DateTimes.of((String)start);
            }

            public DateTime getMaxTime() {
                return DateTimes.of((String)end);
            }

            public String getSegmentIdentifier() {
                return null;
            }

            public Indexed<String> getAvailableDimensions() {
                return null;
            }

            public Iterable<String> getAvailableMetrics() {
                return null;
            }

            @Nullable
            public Comparable getMinValue(String column) {
                return null;
            }

            @Nullable
            public Comparable getMaxValue(String column) {
                return null;
            }

            public Capabilities getCapabilities() {
                return Capabilities.builder().dimensionValuesSorted(true).build();
            }

            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return null;
            }

            @Nullable
            public String getColumnTypeName(String column) {
                return null;
            }

            public int getNumRows() {
                return 0;
            }

            public DateTime getMaxIngestedEventTime() {
                return null;
            }

            public Metadata getMetadata() {
                return null;
            }

            public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
                return null;
            }
        };
        return adapter;
    }

    private DimensionSelector makeFakeDimSelector(final int cardinality) {
        DimensionSelector dimSelector = new DimensionSelector(){

            public int getValueCardinality() {
                return cardinality;
            }

            public IndexedInts getRow() {
                return null;
            }

            public ValueMatcher makeValueMatcher(@Nullable String value) {
                return null;
            }

            public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
                return null;
            }

            @Nullable
            public String lookupName(int id) {
                return null;
            }

            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }

            @Nullable
            public Object getObject() {
                return null;
            }

            public Class classOfObject() {
                return null;
            }
        };
        return dimSelector;
    }
}

