/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import io.druid.collections.ResourceHolder;
import io.druid.query.topn.PooledTopNAlgorithm;
import io.druid.segment.StorageAdapter;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.easymock.EasyMock;
import org.junit.Test;

public class PooledTopNAlgorithmTest {
    @Test
    public void testCleanupWithNullParams() {
        PooledTopNAlgorithm pooledTopNAlgorithm = new PooledTopNAlgorithm((StorageAdapter)EasyMock.mock(StorageAdapter.class), null, null);
        pooledTopNAlgorithm.cleanup(null);
    }

    @Test
    public void cleanup() throws IOException {
        PooledTopNAlgorithm pooledTopNAlgorithm = new PooledTopNAlgorithm((StorageAdapter)EasyMock.mock(StorageAdapter.class), null, null);
        PooledTopNAlgorithm.PooledTopNParams params = (PooledTopNAlgorithm.PooledTopNParams)EasyMock.createMock(PooledTopNAlgorithm.PooledTopNParams.class);
        ResourceHolder resourceHolder = (ResourceHolder)EasyMock.createMock(ResourceHolder.class);
        EasyMock.expect((Object)params.getResultsBufHolder()).andReturn((Object)resourceHolder).times(1);
        EasyMock.expect((Object)resourceHolder.get()).andReturn((Object)ByteBuffer.allocate(1)).times(1);
        resourceHolder.close();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{params});
        EasyMock.replay((Object[])new Object[]{resourceHolder});
        pooledTopNAlgorithm.cleanup(params);
        EasyMock.verify((Object[])new Object[]{params});
        EasyMock.verify((Object[])new Object[]{resourceHolder});
    }
}

