/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.query.ordering.StringComparators;
import io.druid.query.topn.DimensionTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.segment.TestHelper;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class DimensionTopNMetricSpecTest {
    @Test
    public void testSerdeAlphaNumericDimensionTopNMetricSpec() throws IOException {
        DimensionTopNMetricSpec expectedMetricSpec = new DimensionTopNMetricSpec(null, StringComparators.ALPHANUMERIC);
        DimensionTopNMetricSpec expectedMetricSpec1 = new DimensionTopNMetricSpec("test", StringComparators.ALPHANUMERIC);
        String jsonSpec = "{\n    \"type\": \"dimension\",    \"ordering\": \"alphanumeric\"\n}";
        String jsonSpec1 = "{\n    \"type\": \"dimension\",    \"ordering\": \"alphanumeric\",\n    \"previousStop\": \"test\"\n}";
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TopNMetricSpec actualMetricSpec = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        TopNMetricSpec actualMetricSpec1 = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec1, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        Assert.assertEquals((Object)expectedMetricSpec, (Object)actualMetricSpec);
        Assert.assertEquals((Object)expectedMetricSpec1, (Object)actualMetricSpec1);
    }

    @Test
    public void testSerdeLexicographicDimensionTopNMetricSpec() throws IOException {
        DimensionTopNMetricSpec expectedMetricSpec = new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC);
        DimensionTopNMetricSpec expectedMetricSpec1 = new DimensionTopNMetricSpec("test", StringComparators.LEXICOGRAPHIC);
        String jsonSpec = "{\n    \"type\": \"dimension\",    \"ordering\": \"lexicographic\"\n}";
        String jsonSpec1 = "{\n    \"type\": \"dimension\",    \"ordering\": \"lexicographic\",\n    \"previousStop\": \"test\"\n}";
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TopNMetricSpec actualMetricSpec = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        TopNMetricSpec actualMetricSpec1 = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec1, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        Assert.assertEquals((Object)expectedMetricSpec, (Object)actualMetricSpec);
        Assert.assertEquals((Object)expectedMetricSpec1, (Object)actualMetricSpec1);
    }

    @Test
    public void testSerdeStrlenDimensionTopNMetricSpec() throws IOException {
        DimensionTopNMetricSpec expectedMetricSpec = new DimensionTopNMetricSpec(null, StringComparators.STRLEN);
        DimensionTopNMetricSpec expectedMetricSpec1 = new DimensionTopNMetricSpec("test", StringComparators.STRLEN);
        String jsonSpec = "{\n    \"type\": \"dimension\",    \"ordering\": \"strlen\"\n}";
        String jsonSpec1 = "{\n    \"type\": \"dimension\",    \"ordering\": \"strlen\",\n    \"previousStop\": \"test\"\n}";
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TopNMetricSpec actualMetricSpec = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        TopNMetricSpec actualMetricSpec1 = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec1, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        Assert.assertEquals((Object)expectedMetricSpec, (Object)actualMetricSpec);
        Assert.assertEquals((Object)expectedMetricSpec1, (Object)actualMetricSpec1);
    }

    @Test
    public void testSerdeNumericDimensionTopNMetricSpec() throws IOException {
        DimensionTopNMetricSpec expectedMetricSpec = new DimensionTopNMetricSpec(null, StringComparators.NUMERIC);
        DimensionTopNMetricSpec expectedMetricSpec1 = new DimensionTopNMetricSpec("test", StringComparators.NUMERIC);
        String jsonSpec = "{\n    \"type\": \"dimension\",    \"ordering\": \"numeric\"\n}";
        String jsonSpec1 = "{\n    \"type\": \"dimension\",    \"ordering\": \"numeric\",\n    \"previousStop\": \"test\"\n}";
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TopNMetricSpec actualMetricSpec = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        TopNMetricSpec actualMetricSpec1 = (TopNMetricSpec)jsonMapper.readValue(jsonMapper.writeValueAsString(jsonMapper.readValue(jsonSpec1, TopNMetricSpec.class)), DimensionTopNMetricSpec.class);
        Assert.assertEquals((Object)expectedMetricSpec, (Object)actualMetricSpec);
        Assert.assertEquals((Object)expectedMetricSpec1, (Object)actualMetricSpec1);
    }
}

