/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeseries;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.TestHelper;
import io.druid.segment.VirtualColumns;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryQueryToolChestTest {
    private static final TimeseriesQueryQueryToolChest TOOL_CHEST = new TimeseriesQueryQueryToolChest(null);
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public TimeseriesQueryQueryToolChestTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = TOOL_CHEST.getCacheStrategy(new TimeseriesQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), this.descending, VirtualColumns.EMPTY, null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)new LongSumAggregatorFactory("metric0", "metric0")), null, null));
        Result result = new Result(DateTimes.utc((long)123L), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"metric1", (Object)2, (Object)"metric0", (Object)3)));
        Object preparedValue = strategy.prepareForCache().apply((Object)result);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }

    @Test
    public void testCacheKey() throws Exception {
        TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new CountAggregatorFactory("metric1"), (Object)new LongSumAggregatorFactory("metric0", "metric0"))).build();
        TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("dummy").intervals("2015-01-01/2015-01-02").descending(this.descending).granularity(Granularities.ALL).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("metric0", "metric0"), (Object)new CountAggregatorFactory("metric1"))).build();
        Assert.assertFalse((boolean)Arrays.equals(TOOL_CHEST.getCacheStrategy(query1).computeCacheKey((Query)query1), TOOL_CHEST.getCacheStrategy(query2).computeCacheKey((Query)query2)));
    }
}

