/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.Intervals;
import io.druid.query.DataSource;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.TableDataSource;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectQuery;
import io.druid.query.select.SelectQueryConfig;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SelectQuerySpecTest {
    private final ObjectMapper objectMapper = new DefaultObjectMapper();

    public SelectQuerySpecTest() {
        this.objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(SelectQueryConfig.class, (Object)new SelectQueryConfig(Boolean.valueOf(true))));
    }

    @Test
    public void testSerializationLegacyString() throws Exception {
        String legacy = "{\"queryType\":\"select\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"descending\":true,\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[\"market\",\"quality\"],\"metrics\":[\"index\"],\"virtualColumns\":null,\"pagingSpec\":{\"pagingIdentifiers\":{},\"threshold\":3},\"context\":null}";
        String current = "{\"queryType\":\"select\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"descending\":true,\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"market\",\"outputName\":\"market\",\"outputType\":\"STRING\"},{\"type\":\"default\",\"dimension\":\"quality\",\"outputName\":\"quality\",\"outputType\":\"STRING\"}],\"metrics\":[\"index\"],\"virtualColumns\":[],\"pagingSpec\":{\"pagingIdentifiers\":{},\"threshold\":3,\"fromNext\":true},\"context\":null}";
        SelectQuery query = new SelectQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), true, null, QueryRunnerTestHelper.allGran, DefaultDimensionSpec.toSpec(Arrays.asList("market", "quality")), Arrays.asList("index"), null, new PagingSpec(null, 3, null), null);
        String actual = this.objectMapper.writeValueAsString((Object)query);
        Assert.assertEquals((Object)current, (Object)actual);
        Assert.assertEquals((Object)query, (Object)this.objectMapper.readValue(actual, SelectQuery.class));
        Assert.assertEquals((Object)query, (Object)this.objectMapper.readValue(legacy, SelectQuery.class));
    }

    @Test
    public void testPagingSpecFromNext() throws Exception {
        String baseQueryJson = "{\"queryType\":\"select\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"descending\":true,\"filter\":null,\"granularity\":{\"type\":\"all\"},\"dimensions\":[{\"type\":\"default\",\"dimension\":\"market\",\"outputName\":\"market\",\"outputType\":\"STRING\"},{\"type\":\"default\",\"dimension\":\"quality\",\"outputName\":\"quality\",\"outputType\":\"STRING\"}],\"metrics\":[\"index\"],\"virtualColumns\":[],";
        String withFalse = baseQueryJson + "\"pagingSpec\":{\"pagingIdentifiers\":{},\"threshold\":3,\"fromNext\":false},\"context\":null}";
        String withTrue = baseQueryJson + "\"pagingSpec\":{\"pagingIdentifiers\":{},\"threshold\":3,\"fromNext\":true},\"context\":null}";
        SelectQuery queryWithNull = new SelectQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), true, null, QueryRunnerTestHelper.allGran, DefaultDimensionSpec.toSpec(Arrays.asList("market", "quality")), Arrays.asList("index"), null, new PagingSpec(null, 3, null), null);
        SelectQuery queryWithFalse = queryWithNull.withPagingSpec(new PagingSpec(null, 3, Boolean.valueOf(false)));
        SelectQuery queryWithTrue = queryWithNull.withPagingSpec(new PagingSpec(null, 3, Boolean.valueOf(true)));
        String actualWithNull = this.objectMapper.writeValueAsString((Object)queryWithNull);
        Assert.assertEquals((Object)withTrue, (Object)actualWithNull);
        String actualWithFalse = this.objectMapper.writeValueAsString((Object)queryWithFalse);
        Assert.assertEquals((Object)withFalse, (Object)actualWithFalse);
        String actualWithTrue = this.objectMapper.writeValueAsString((Object)queryWithTrue);
        Assert.assertEquals((Object)withTrue, (Object)actualWithTrue);
        Assert.assertEquals((Object)queryWithNull, (Object)this.objectMapper.readValue(actualWithNull, SelectQuery.class));
        Assert.assertEquals((Object)queryWithFalse, (Object)this.objectMapper.readValue(actualWithFalse, SelectQuery.class));
        Assert.assertEquals((Object)queryWithTrue, (Object)this.objectMapper.readValue(actualWithTrue, SelectQuery.class));
    }
}

