/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.LegacyDimensionSpec;
import io.druid.query.search.SearchQuery;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class SearchQueryTest {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).query("a").build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testEquals() {
        SearchQuery query1 = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions((DimensionSpec)new DefaultDimensionSpec("quality", "quality")).query("a").build();
        SearchQuery query2 = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions((DimensionSpec)new DefaultDimensionSpec("quality", "quality")).query("a").build();
        Assert.assertEquals((Object)query1, (Object)query2);
    }

    @Test
    public void testSerDe() throws IOException {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions((DimensionSpec)new LegacyDimensionSpec((Object)"quality")).query("a").build();
        String json = "{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}";
        Query serdeQuery = (Query)jsonMapper.readValue("{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}", Query.class);
        Assert.assertEquals((Object)query.toString(), (Object)serdeQuery.toString());
        Assert.assertEquals((Object)query, (Object)serdeQuery);
        String json2 = "{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}";
        Query serdeQuery2 = (Query)jsonMapper.readValue("{\"queryType\":\"search\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"limit\":1000,\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z\"]},\"searchDimensions\":[\"quality\"],\"query\":{\"type\":\"insensitive_contains\",\"value\":\"a\"},\"sort\":{\"type\":\"lexicographic\"},\"context\":null}", Query.class);
        Assert.assertEquals((Object)query.toString(), (Object)serdeQuery2.toString());
        Assert.assertEquals((Object)query, (Object)serdeQuery2);
    }
}

