/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.collect.ImmutableSet;
import io.druid.java.util.emitter.core.Emitter;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.CachingEmitter;
import io.druid.query.DefaultQueryMetricsTest;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ListFilteredDimensionSpec;
import io.druid.query.search.DefaultSearchQueryMetricsFactory;
import io.druid.query.search.SearchQuery;
import io.druid.query.search.SearchQueryMetrics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSearchQueryMetricsTest {
    @Test
    public void testDefaultSearchQueryMetricsQuery() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.fullOnInterval).dimensions((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).build();
        SearchQueryMetrics queryMetrics = DefaultSearchQueryMetricsFactory.instance().makeMetrics(query);
        queryMetrics.query((Query)query);
        queryMetrics.reportQueryTime(0L).emit(serviceEmitter);
        Map actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((long)12L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"testing", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        List expectedIntervals = QueryRunnerTestHelper.fullOnInterval.getIntervals();
        List expectedStringIntervals = expectedIntervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
        Assert.assertEquals(expectedStringIntervals, actualEvent.get("interval"));
        Assert.assertEquals((Object)"false", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)((Interval)expectedIntervals.get(0)).toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"", actualEvent.get("id"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
    }

    @Test
    public void testDefaultSearchQueryMetricsMetricNamesAndUnits() {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.dayGran).intervals(QueryRunnerTestHelper.fullOnInterval).build();
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        SearchQueryMetrics queryMetrics = DefaultSearchQueryMetricsFactory.instance().makeMetrics(query);
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(cachingEmitter, serviceEmitter, queryMetrics);
    }
}

