/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.google.common.collect.Lists;
import io.druid.data.input.impl.DimensionSchema;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.LegacyDataSource;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.metadata.SegmentMetadataQueryConfig;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestIndex;
import io.druid.segment.column.ValueType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class SegmentAnalyzerTest {
    private static final EnumSet<SegmentMetadataQuery.AnalysisType> emptyAnalyses = EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class);

    @Test
    public void testIncrementalWorks() throws Exception {
        this.testIncrementalWorksHelper(null);
        this.testIncrementalWorksHelper(emptyAnalyses);
    }

    private void testIncrementalWorksHelper(EnumSet<SegmentMetadataQuery.AnalysisType> analyses) throws Exception {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), null), analyses);
        Assert.assertEquals((long)1L, (long)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals(null, (Object)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((long)(TestIndex.COLUMNS.length + 3), (long)columns.size());
        for (DimensionSchema schema : TestIndex.DIMENSION_SCHEMAS) {
            String dimension = schema.getName();
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            boolean isString = schema.getValueType().name().equals(ValueType.STRING.name());
            Assert.assertEquals((String)dimension, (Object)schema.getValueType().name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getSize());
            if (isString) {
                if (analyses == null) {
                    Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getCardinality().longValue());
                continue;
            }
            Assert.assertNull((String)dimension, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.DOUBLE_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.DOUBLE.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.FLOAT_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.FLOAT.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    @Test
    public void testMappedWorks() throws Exception {
        this.testMappedWorksHelper(null);
        this.testMappedWorksHelper(emptyAnalyses);
    }

    private void testMappedWorksHelper(EnumSet<SegmentMetadataQuery.AnalysisType> analyses) throws Exception {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new QueryableIndexSegment("test_1", TestIndex.getMMappedTestIndex()), analyses);
        Assert.assertEquals((long)1L, (long)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals((Object)"test_1", (Object)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((long)(TestIndex.COLUMNS.length + 3 - 1), (long)columns.size());
        for (DimensionSchema schema : TestIndex.DIMENSION_SCHEMAS) {
            String dimension = schema.getName();
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            if (dimension.equals("null_column")) {
                Assert.assertNull((Object)columnAnalysis);
                continue;
            }
            boolean isString = schema.getValueType().name().equals(ValueType.STRING.name());
            Assert.assertEquals((String)dimension, (Object)schema.getValueType().name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getSize());
            if (isString) {
                if (analyses == null) {
                    Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getCardinality().longValue());
                continue;
            }
            Assert.assertNull((String)dimension, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.DOUBLE_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.DOUBLE.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.FLOAT_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.FLOAT.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    private List<SegmentAnalysis> getSegmentAnalysises(Segment index, EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), index, null);
        SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new LegacyDataSource("test"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2011/2012"), null, null, null, analyses, Boolean.valueOf(false), Boolean.valueOf(false));
        HashMap context = new HashMap();
        return Sequences.toList((Sequence)runner.run(QueryPlus.wrap((Query)query), context), (List)Lists.newArrayList());
    }
}

