/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.GrouperTestUtil;
import io.druid.query.groupby.epinephelinae.StreamingMergeSortedGrouper;
import io.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamingMergeSortedGrouperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testAggregate() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<Integer> grouper = this.newGrouper(columnSelectorFactory, 1024);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)10);
        grouper.aggregate((Object)12);
        grouper.aggregate((Object)12);
        grouper.finish();
        ImmutableList expected = ImmutableList.of((Object)new Grouper.Entry((Object)6, new Object[]{30L, 3L}), (Object)new Grouper.Entry((Object)10, new Object[]{10L, 1L}), (Object)new Grouper.Entry((Object)12, new Object[]{20L, 2L}));
        ArrayList unsortedEntries = Lists.newArrayList((Iterator)grouper.iterator(true));
        Assert.assertEquals((Object)expected, (Object)unsortedEntries);
    }

    @Test(timeout=5000L)
    public void testEmptyIterator() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<Integer> grouper = this.newGrouper(columnSelectorFactory, 1024);
        grouper.finish();
        Assert.assertTrue((!grouper.iterator(true).hasNext() ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testStreamingAggregateWithLargeBuffer() throws ExecutionException, InterruptedException {
        this.testStreamingAggregate(1024);
    }

    @Test(timeout=5000L)
    public void testStreamingAggregateWithMinimumBuffer() throws ExecutionException, InterruptedException {
        this.testStreamingAggregate(60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStreamingAggregate(int bufferSize) throws ExecutionException, InterruptedException {
        ExecutorService exec = Execs.multiThreaded((int)2, (String)"merge-sorted-grouper-test-%d");
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<Integer> grouper = this.newGrouper(columnSelectorFactory, bufferSize);
        ArrayList<Grouper.Entry> expected = new ArrayList<Grouper.Entry>(1024);
        for (int i = 0; i < 1024; ++i) {
            expected.add(new Grouper.Entry((Object)i, new Object[]{100L, 10L}));
        }
        try {
            Future<?> future = exec.submit(() -> {
                columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
                for (int i = 0; i < 1024; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        grouper.aggregate((Object)i);
                    }
                }
                grouper.finish();
            });
            ArrayList unsortedEntries = Lists.newArrayList((Iterator)grouper.iterator(true));
            List actual = Ordering.from((o1, o2) -> Ints.compare((int)((Integer)o1.getKey()), (int)((Integer)o2.getKey()))).sortedCopy((Iterable)unsortedEntries);
            if (!actual.equals(expected)) {
                future.get();
                Assert.fail();
            }
        }
        finally {
            exec.shutdownNow();
        }
    }

    @Test
    public void testNotEnoughBuffer() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Buffer[50] should be large enough to store at least three records[20]");
        this.newGrouper(GrouperTestUtil.newColumnSelectorFactory(), 50);
    }

    @Test
    public void testTimeout() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(TimeoutException.class));
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        StreamingMergeSortedGrouper<Integer> grouper = this.newGrouper(columnSelectorFactory, 60);
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)6);
        grouper.iterator();
    }

    private StreamingMergeSortedGrouper<Integer> newGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        StreamingMergeSortedGrouper grouper = new StreamingMergeSortedGrouper(Suppliers.ofInstance((Object)buffer), GrouperTestUtil.intKeySerde(), (ColumnSelectorFactory)columnSelectorFactory, new AggregatorFactory[]{new LongSumAggregatorFactory("valueSum", "value"), new CountAggregatorFactory("count")}, System.currentTimeMillis() + 1000L);
        grouper.init();
        return grouper;
    }
}

