/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.IAE;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.GrouperTestUtil;
import io.druid.query.groupby.epinephelinae.LimitedBufferHashGrouper;
import io.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LimitedBufferHashGrouperTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLimitAndBufferSwapping() {
        int i;
        int limit = 100;
        int keyBase = 100000;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<Integer> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 20000, 2, 100);
        int numRows = 1000;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)(i + 100000)).isOk());
        }
        Assert.assertEquals((long)12L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)112L, (long)grouper.getSize());
        Assert.assertEquals((long)349L, (long)grouper.getBuckets());
        Assert.assertEquals((long)174L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertEquals((long)25L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)150L, (long)grouper.getSize());
        Assert.assertEquals((long)349L, (long)grouper.getBuckets());
        Assert.assertEquals((long)174L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        ArrayList expected = Lists.newArrayList();
        for (int i2 = 0; i2 < 100; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{11L, 1L}));
        }
        Assert.assertEquals((Object)expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    @Test
    public void testBufferTooSmall() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("WTF? Using LimitedBufferHashGrouper with insufficient buffer capacity.");
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 10, 2, 100);
    }

    @Test
    public void testMinBufferSize() {
        int i;
        int limit = 100;
        int keyBase = 100000;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        LimitedBufferHashGrouper<Integer> grouper = LimitedBufferHashGrouperTest.makeGrouper(columnSelectorFactory, 11716, 2, 100);
        int numRows = 1000;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i + 100000), (boolean)grouper.aggregate((Object)(i + 100000)).isOk());
        }
        Assert.assertEquals((long)899L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)101L, (long)grouper.getSize());
        Assert.assertEquals((long)202L, (long)grouper.getBuckets());
        Assert.assertEquals((long)101L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertEquals((long)1899L, (long)grouper.getGrowthCount());
        Assert.assertEquals((long)101L, (long)grouper.getSize());
        Assert.assertEquals((long)202L, (long)grouper.getBuckets());
        Assert.assertEquals((long)101L, (long)grouper.getMaxSize());
        Assert.assertEquals((long)100L, (long)grouper.getLimit());
        ArrayList expected = Lists.newArrayList();
        for (int i2 = 0; i2 < 100; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{11L, 1L}));
        }
        Assert.assertEquals((Object)expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    private static LimitedBufferHashGrouper<Integer> makeGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize, int initialBuckets, int limit) {
        LimitedBufferHashGrouper grouper = new LimitedBufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(bufferSize)), GrouperTestUtil.intKeySerde(), (ColumnSelectorFactory)columnSelectorFactory, new AggregatorFactory[]{new LongSumAggregatorFactory("valueSum", "value"), new CountAggregatorFactory("count")}, Integer.MAX_VALUE, 0.5f, initialBuckets, limit, false);
        grouper.init();
        return grouper;
    }
}

