/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.collections.ResourceHolder;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.parsers.CloseableIterator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.epinephelinae.ConcurrentGrouper;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.column.ColumnCapabilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConcurrentGrouperTest {
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(8);
    private static final TestResourceHolder TEST_RESOURCE_HOLDER = new TestResourceHolder(256);
    private static final Grouper.KeySerdeFactory<Long> KEY_SERDE_FACTORY = new TestKeySerdeFactory();
    private static final Supplier<ResourceHolder<ByteBuffer>> COMBINE_BUFFER_SUPPLIER = new TestBufferSupplier();
    private static final ColumnSelectorFactory NULL_FACTORY = new TestColumnSelectorFactory();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Supplier<ByteBuffer> bufferSupplier;

    @Parameterized.Parameters(name="bufferSize={0}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{32768}, (Object)new Object[]{0x100000});
    }

    @AfterClass
    public static void teardown() {
        SERVICE.shutdown();
    }

    public ConcurrentGrouperTest(final int bufferSize) {
        this.bufferSupplier = new Supplier<ByteBuffer>(){
            private final AtomicBoolean called = new AtomicBoolean(false);
            private ByteBuffer buffer;

            public ByteBuffer get() {
                if (this.called.compareAndSet(false, true)) {
                    this.buffer = ByteBuffer.allocate(bufferSize);
                }
                return this.buffer;
            }
        };
    }

    @Test
    public void testAggregate() throws InterruptedException, ExecutionException, IOException {
        final ConcurrentGrouper grouper = new ConcurrentGrouper(this.bufferSupplier, COMBINE_BUFFER_SUPPLIER, KEY_SERDE_FACTORY, KEY_SERDE_FACTORY, NULL_FACTORY, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, 1024, 0.7f, 1, new LimitedTemporaryStorage(this.temporaryFolder.newFolder(), 0x100000L), (ObjectMapper)new DefaultObjectMapper(), 8, null, false, MoreExecutors.listeningDecorator((ExecutorService)SERVICE), 0, false, 0L, 4, 8);
        grouper.init();
        int numRows = 1000;
        Future[] futures = new Future[8];
        for (int i = 0; i < 8; ++i) {
            futures[i] = SERVICE.submit(new Runnable(){

                @Override
                public void run() {
                    for (long i = 0L; i < 1000L; ++i) {
                        grouper.aggregate((Object)i);
                    }
                }
            });
        }
        for (Future eachFuture : futures) {
            eachFuture.get();
        }
        CloseableIterator iterator = grouper.iterator(true);
        ArrayList actual = Lists.newArrayList((Iterator)iterator);
        iterator.close();
        Assert.assertTrue((!TEST_RESOURCE_HOLDER.taken || TEST_RESOURCE_HOLDER.closed ? 1 : 0) != 0);
        ArrayList<Grouper.Entry> expected = new ArrayList<Grouper.Entry>();
        for (long i = 0L; i < 1000L; ++i) {
            expected.add(new Grouper.Entry((Object)i, new Object[]{8L}));
        }
        Assert.assertEquals(expected, (Object)actual);
        grouper.close();
    }

    private static class TestColumnSelectorFactory
    implements ColumnSelectorFactory {
        private TestColumnSelectorFactory() {
        }

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return null;
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            return null;
        }

        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return null;
        }
    }

    private static class TestBufferSupplier
    implements Supplier<ResourceHolder<ByteBuffer>> {
        private final AtomicBoolean called = new AtomicBoolean(false);

        private TestBufferSupplier() {
        }

        public ResourceHolder<ByteBuffer> get() {
            if (this.called.compareAndSet(false, true)) {
                return TEST_RESOURCE_HOLDER;
            }
            throw new IAE("should be called once", new Object[0]);
        }
    }

    static class TestKeySerdeFactory
    implements Grouper.KeySerdeFactory<Long> {
        TestKeySerdeFactory() {
        }

        public long getMaxDictionarySize() {
            return 0L;
        }

        public Grouper.KeySerde<Long> factorize() {
            return new Grouper.KeySerde<Long>(){
                final ByteBuffer buffer = ByteBuffer.allocate(8);

                public int keySize() {
                    return 8;
                }

                public Class<Long> keyClazz() {
                    return Long.class;
                }

                public List<String> getDictionary() {
                    return ImmutableList.of();
                }

                public ByteBuffer toByteBuffer(Long key) {
                    this.buffer.rewind();
                    this.buffer.putLong(key);
                    this.buffer.position(0);
                    return this.buffer;
                }

                public Long fromByteBuffer(ByteBuffer buffer, int position) {
                    return buffer.getLong(position);
                }

                public Grouper.BufferComparator bufferComparator() {
                    return new Grouper.BufferComparator(){

                        public int compare(ByteBuffer lhsBuffer, ByteBuffer rhsBuffer, int lhsPosition, int rhsPosition) {
                            return Longs.compare((long)lhsBuffer.getLong(lhsPosition), (long)rhsBuffer.getLong(rhsPosition));
                        }
                    };
                }

                public Grouper.BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] aggregatorFactories, int[] aggregatorOffsets) {
                    return null;
                }

                public void reset() {
                }
            };
        }

        public Grouper.KeySerde<Long> factorizeWithDictionary(List<String> dictionary) {
            return this.factorize();
        }

        public Comparator<Grouper.Entry<Long>> objectComparator(boolean forceDefaultOrder) {
            return new Comparator<Grouper.Entry<Long>>(){

                @Override
                public int compare(Grouper.Entry<Long> o1, Grouper.Entry<Long> o2) {
                    return ((Long)o1.getKey()).compareTo((Long)o2.getKey());
                }
            };
        }
    }

    static class TestResourceHolder
    implements ResourceHolder<ByteBuffer> {
        private boolean taken;
        private boolean closed;
        private ByteBuffer buffer;

        TestResourceHolder(int bufferSize) {
            this.buffer = ByteBuffer.allocate(bufferSize);
        }

        public ByteBuffer get() {
            this.taken = true;
            return this.buffer;
        }

        public void close() {
            this.closed = true;
        }
    }
}

