/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.epinephelinae;

import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.ByteBufferUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.groupby.epinephelinae.BufferHashGrouper;
import io.druid.query.groupby.epinephelinae.Grouper;
import io.druid.query.groupby.epinephelinae.GrouperTestUtil;
import io.druid.query.groupby.epinephelinae.TestColumnSelectorFactory;
import io.druid.segment.CloserRule;
import io.druid.segment.ColumnSelectorFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BufferHashGrouperTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public CloserRule closerRule = new CloserRule(true);

    @Test
    public void testSimple() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper grouper = new BufferHashGrouper(Suppliers.ofInstance((Object)ByteBuffer.allocate(1000)), GrouperTestUtil.intKeySerde(), (ColumnSelectorFactory)columnSelectorFactory, new AggregatorFactory[]{new LongSumAggregatorFactory("valueSum", "value"), new CountAggregatorFactory("count")}, Integer.MAX_VALUE, 0.0f, 0, true);
        grouper.init();
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        grouper.aggregate((Object)12);
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)10);
        grouper.aggregate((Object)6);
        grouper.aggregate((Object)12);
        grouper.aggregate((Object)12);
        ImmutableList expected = ImmutableList.of((Object)new Grouper.Entry((Object)6, new Object[]{20L, 2L}), (Object)new Grouper.Entry((Object)10, new Object[]{10L, 1L}), (Object)new Grouper.Entry((Object)12, new Object[]{30L, 3L}));
        ArrayList unsortedEntries = Lists.newArrayList((Iterator)grouper.iterator(false));
        ArrayList sortedEntries = Lists.newArrayList((Iterator)grouper.iterator(true));
        Assert.assertEquals((Object)expected, (Object)sortedEntries);
        Assert.assertEquals((Object)expected, (Object)Ordering.from((Comparator)new Comparator<Grouper.Entry<Integer>>(){

            @Override
            public int compare(Grouper.Entry<Integer> o1, Grouper.Entry<Integer> o2) {
                return Ints.compare((int)((Integer)o1.getKey()), (int)((Integer)o2.getKey()));
            }
        }).sortedCopy((Iterable)unsortedEntries));
    }

    @Test
    public void testGrowing() {
        int i;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, 10000, 2);
        int expectedMaxSize = 219;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 219; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)219).isOk());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 219; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)219).isOk());
        ArrayList expected = Lists.newArrayList();
        for (int i2 = 0; i2 < 219; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{21L, 2L}));
        }
        Assert.assertEquals((Object)expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    @Test
    public void testGrowing2() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, 2000000000, 2);
        int expectedMaxSize = 40988516;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (int i = 0; i < 40988516; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)40988516).isOk());
    }

    @Test
    public void testGrowing3() {
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, Integer.MAX_VALUE, 2);
        int expectedMaxSize = 44938972;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (int i = 0; i < 44938972; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)44938972).isOk());
    }

    @Test
    public void testNoGrowing() {
        int i;
        TestColumnSelectorFactory columnSelectorFactory = GrouperTestUtil.newColumnSelectorFactory();
        BufferHashGrouper<Integer> grouper = this.makeGrouper(columnSelectorFactory, 10000, Integer.MAX_VALUE);
        int expectedMaxSize = 267;
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)10L)));
        for (i = 0; i < 267; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)267).isOk());
        columnSelectorFactory.setRow((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"value", (Object)11L)));
        for (i = 0; i < 267; ++i) {
            Assert.assertTrue((String)String.valueOf(i), (boolean)grouper.aggregate((Object)i).isOk());
        }
        Assert.assertFalse((boolean)grouper.aggregate((Object)267).isOk());
        ArrayList expected = Lists.newArrayList();
        for (int i2 = 0; i2 < 267; ++i2) {
            expected.add(new Grouper.Entry((Object)i2, new Object[]{21L, 2L}));
        }
        Assert.assertEquals((Object)expected, (Object)Lists.newArrayList((Iterator)grouper.iterator(true)));
    }

    private BufferHashGrouper<Integer> makeGrouper(TestColumnSelectorFactory columnSelectorFactory, int bufferSize, int initialBuckets) {
        MappedByteBuffer buffer;
        try {
            File file = this.temporaryFolder.newFile();
            try (FileChannel channel = new FileOutputStream(file).getChannel();){
                channel.truncate(bufferSize);
            }
            buffer = Files.map((File)file, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE, (long)bufferSize);
            this.closerRule.closeLater(() -> ByteBufferUtils.unmap((MappedByteBuffer)buffer));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        BufferHashGrouper grouper = new BufferHashGrouper(Suppliers.ofInstance((Object)buffer), GrouperTestUtil.intKeySerde(), (ColumnSelectorFactory)columnSelectorFactory, new AggregatorFactory[]{new LongSumAggregatorFactory("valueSum", "value"), new CountAggregatorFactory("count")}, Integer.MAX_VALUE, 0.75f, initialBuckets, true);
        grouper.init();
        return grouper;
    }
}

