/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.Druids;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.groupby.GroupByQueryRunnerTest;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryRunnerTest;
import io.druid.query.timeseries.TimeseriesResultValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByTimeseriesQueryRunnerTest
extends TimeseriesQueryRunnerTest {
    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        GroupByQueryConfig config = new GroupByQueryConfig();
        config.setMaxIntermediateRows(10000);
        final GroupByQueryRunnerFactory factory = GroupByQueryRunnerTest.makeQueryRunnerFactory(config);
        return QueryRunnerTestHelper.transformToConstructionFeeder(Lists.transform(QueryRunnerTestHelper.makeQueryRunners(factory), (Function)new Function<QueryRunner<Row>, Object>(){

            @Nullable
            public Object apply(final QueryRunner<Row> input) {
                return new QueryRunner(){

                    public Sequence run(QueryPlus queryPlus, Map responseContext) {
                        TimeseriesQuery tsQuery = (TimeseriesQuery)queryPlus.getQuery();
                        QueryRunner newRunner = factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)ImmutableList.of((Object)input));
                        QueryToolChest toolChest = factory.getToolchest();
                        newRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(toolChest.preMergeQueryDecoration(newRunner)), toolChest);
                        GroupByQuery newQuery = GroupByQuery.builder().setDataSource(tsQuery.getDataSource()).setQuerySegmentSpec(tsQuery.getQuerySegmentSpec()).setGranularity(tsQuery.getGranularity()).setDimFilter(tsQuery.getDimensionsFilter()).setAggregatorSpecs(tsQuery.getAggregatorSpecs()).setPostAggregatorSpecs(tsQuery.getPostAggregatorSpecs()).setVirtualColumns(tsQuery.getVirtualColumns()).setContext(tsQuery.getContext()).build();
                        return Sequences.map((Sequence)newRunner.run(queryPlus.withQuery((Query)newQuery), responseContext), (Function)new Function<Row, Result<TimeseriesResultValue>>(){

                            public Result<TimeseriesResultValue> apply(Row input) {
                                MapBasedRow row = (MapBasedRow)input;
                                return new Result(row.getTimestamp(), (Object)new TimeseriesResultValue(row.getEvent()));
                            }
                        });
                    }

                    public String toString() {
                        return input.toString();
                    }
                };
            }
        }));
    }

    public GroupByTimeseriesQueryRunnerTest(QueryRunner runner) {
        super(runner, false, QueryRunnerTestHelper.commonDoubleAggregators);
    }

    @Override
    @Test
    public void testFullOnTimeseriesMaxMin() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Arrays.asList(new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index"))).descending(this.descending).build();
        DateTime expectedEarliest = DateTimes.of((String)"1970-01-01");
        DateTime expectedLast = DateTimes.of((String)"2011-04-15");
        List results = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), CONTEXT), (List)Lists.newArrayList());
        Result result = (Result)results.iterator().next();
        Assert.assertEquals((Object)expectedEarliest, (Object)result.getTimestamp());
        Assert.assertFalse((String)StringUtils.format((String)"Timestamp[%s] > expectedLast[%s]", (Object[])new Object[]{result.getTimestamp(), expectedLast}), (boolean)result.getTimestamp().isAfter((ReadableInstant)expectedLast));
        TimeseriesResultValue value = (TimeseriesResultValue)result.getValue();
        Assert.assertEquals((String)result.toString(), (double)1870.061029, (double)value.getDoubleMetric("maxIndex"), (double)0.0018700610289999998);
        Assert.assertEquals((String)result.toString(), (double)59.021022, (double)value.getDoubleMetric("minIndex"), (double)5.9021021999999996E-5);
    }

    @Override
    public void testEmptyTimeseries() {
    }

    @Override
    public void testFullOnTimeseries() {
    }

    @Override
    public void testFullOnTimeseriesWithFilter() {
    }

    @Override
    public void testTimeseriesQueryZeroFilling() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilter() {
    }

    @Override
    public void testTimeseriesWithNonExistentFilterAndMultiDim() {
    }

    @Override
    public void testTimeseriesWithFilterOnNonExistentDimension() {
    }
}

