/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.collections.BlockingPool;
import io.druid.collections.DefaultBlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.ReferenceCountingResourceHolder;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.query.DataSource;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.InsufficientResourcesException;
import io.druid.query.Query;
import io.druid.query.QueryDataSource;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.ResourceLimitExceededException;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.groupby.GroupByQueryRunnerTest;
import io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import io.druid.query.groupby.strategy.GroupByStrategySelector;
import io.druid.query.groupby.strategy.GroupByStrategyV1;
import io.druid.query.groupby.strategy.GroupByStrategyV2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupByQueryRunnerFailureTest {
    private static final DruidProcessingConfig DEFAULT_PROCESSING_CONFIG = new DruidProcessingConfig(){

        public String getFormatString() {
            return null;
        }

        public int intermediateComputeSizeBytes() {
            return 0xA00000;
        }

        public int getNumMergeBuffers() {
            return 1;
        }

        public int getNumThreads() {
            return 2;
        }
    };
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final BlockingPool<ByteBuffer> mergeBufferPool = new DefaultBlockingPool((Supplier)new Supplier<ByteBuffer>(){

        public ByteBuffer get() {
            return ByteBuffer.allocateDirect(DEFAULT_PROCESSING_CONFIG.intermediateComputeSizeBytes());
        }
    }, DEFAULT_PROCESSING_CONFIG.getNumMergeBuffers());
    private static final GroupByQueryRunnerFactory factory = GroupByQueryRunnerFailureTest.makeQueryRunnerFactory(GroupByQueryRunnerTest.DEFAULT_MAPPER, new GroupByQueryConfig(){

        public String getDefaultStrategy() {
            return "v2";
        }
    });
    private QueryRunner<Row> runner;

    private static GroupByQueryRunnerFactory makeQueryRunnerFactory(ObjectMapper mapper, GroupByQueryConfig config) {
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        StupidPool bufferPool = new StupidPool("GroupByQueryEngine-bufferPool", (Supplier)new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                return ByteBuffer.allocateDirect(DEFAULT_PROCESSING_CONFIG.intermediateComputeSizeBytes());
            }
        });
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (NonBlockingPool)bufferPool), new GroupByStrategyV2(DEFAULT_PROCESSING_CONFIG, configSupplier, (NonBlockingPool)bufferPool, mergeBufferPool, mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER));
        GroupByQueryQueryToolChest toolChest = new GroupByQueryQueryToolChest(strategySelector, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        return new GroupByQueryRunnerFactory(strategySelector, toolChest);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() throws IOException {
        ArrayList args = Lists.newArrayList();
        for (QueryRunner runner : QueryRunnerTestHelper.makeQueryRunners(factory)) {
            args.add(new Object[]{runner});
        }
        return args;
    }

    public GroupByQueryRunnerFailureTest(QueryRunner<Row> runner) {
        this.runner = factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), (Iterable)ImmutableList.of(runner));
    }

    @Test(timeout=10000L)
    public void testNotEnoughMergeBuffersOnQueryable() throws IOException {
        this.expectedException.expect(QueryInterruptedException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(TimeoutException.class));
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)500)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
    }

    @Test(timeout=10000L)
    public void testResourceLimitExceededOnBroker() {
        this.expectedException.expect(ResourceLimitExceededException.class);
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias"), new DefaultDimensionSpec("market", null)})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build()).setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)500)).build();
        GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
    }

    @Test(timeout=10000L, expected=InsufficientResourcesException.class)
    public void testInsufficientResourcesOnBroker() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("testing").setInterval(QueryRunnerTestHelper.firstToThird).setGranularity(Granularities.ALL).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{QueryRunnerTestHelper.rowsCount})).build())).setGranularity(Granularities.ALL).setInterval(QueryRunnerTestHelper.firstToThird).setAggregatorSpecs((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new LongSumAggregatorFactory("rows", "rows")})).setContext((Map)ImmutableMap.of((Object)"timeout", (Object)500)).build();
        try (ReferenceCountingResourceHolder holder = mergeBufferPool.takeBatch(1, 10L);){
            GroupByQueryRunnerTestHelper.runQuery((QueryRunnerFactory)factory, this.runner, query);
        }
    }
}

