/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import io.druid.collections.BlockingPool;
import io.druid.collections.DefaultBlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.StupidPool;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.Row;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.LongDimensionSchema;
import io.druid.data.input.impl.StringDimensionSchema;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.concurrent.Execs;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.logger.Logger;
import io.druid.math.expr.ExprMacroTable;
import io.druid.query.BySegmentQueryRunner;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.query.groupby.GroupByQueryRunnerFactory;
import io.druid.query.groupby.GroupByQueryRunnerTestHelper;
import io.druid.query.groupby.having.GreaterThanHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.groupby.strategy.GroupByStrategySelector;
import io.druid.query.groupby.strategy.GroupByStrategyV1;
import io.druid.query.groupby.strategy.GroupByStrategyV2;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GroupByMultiSegmentTest {
    private static final IndexMergerV9 INDEX_MERGER_V9;
    private static final IndexIO INDEX_IO;
    public static final ObjectMapper JSON_MAPPER;
    private File tmpDir;
    private QueryRunnerFactory<Row, GroupByQuery> groupByFactory;
    private List<IncrementalIndex> incrementalIndices = Lists.newArrayList();
    private List<QueryableIndex> groupByIndices = Lists.newArrayList();
    private ExecutorService executorService;
    public static final QueryWatcher NOOP_QUERYWATCHER;

    private IncrementalIndex makeIncIndex(boolean withRollup) {
        return new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withDimensionsSpec(new DimensionsSpec(Arrays.asList(new StringDimensionSchema("dimA"), new LongDimensionSchema("metA")), null, null)).withRollup(withRollup).build()).setReportParseExceptions(false).setConcurrentEventAdd(true).setMaxRowCount(1000).buildOnheap();
    }

    @Before
    public void setup() throws Exception {
        this.tmpDir = Files.createTempDir();
        List<String> dimNames = Arrays.asList("dimA", "metA");
        IncrementalIndex indexA = this.makeIncIndex(false);
        this.incrementalIndices.add(indexA);
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("dimA", "hello");
        event.put("metA", 100);
        MapBasedInputRow row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "world");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexA.add((InputRow)row);
        File fileA = INDEX_MERGER_V9.persist(indexA, new File(this.tmpDir, "A"), new IndexSpec(), null);
        QueryableIndex qindexA = INDEX_IO.loadIndex(fileA);
        IncrementalIndex indexB = this.makeIncIndex(false);
        this.incrementalIndices.add(indexB);
        event = new HashMap();
        event.put("dimA", "foo");
        event.put("metA", 100);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        event = new HashMap();
        event.put("dimA", "world");
        event.put("metA", 75);
        row = new MapBasedInputRow(1000L, dimNames, event);
        indexB.add((InputRow)row);
        File fileB = INDEX_MERGER_V9.persist(indexB, new File(this.tmpDir, "B"), new IndexSpec(), null);
        QueryableIndex qindexB = INDEX_IO.loadIndex(fileB);
        this.groupByIndices = Arrays.asList(qindexA, qindexB);
        this.setupGroupByFactory();
    }

    private void setupGroupByFactory() {
        this.executorService = Execs.multiThreaded((int)2, (String)"GroupByThreadPool[%d]");
        StupidPool bufferPool = new StupidPool("GroupByBenchmark-computeBufferPool", (Supplier)new OffheapBufferGenerator("compute", 10000000), 0, Integer.MAX_VALUE);
        DefaultBlockingPool mergePool = new DefaultBlockingPool((Supplier)new OffheapBufferGenerator("merge", 10000000), 2);
        GroupByQueryConfig config = new GroupByQueryConfig(){

            public String getDefaultStrategy() {
                return "v2";
            }

            public int getBufferGrouperInitialBuckets() {
                return -1;
            }

            public long getMaxOnDiskStorage() {
                return 1000000000L;
            }
        };
        config.setSingleThreaded(false);
        config.setMaxIntermediateRows(Integer.MAX_VALUE);
        config.setMaxResults(Integer.MAX_VALUE);
        DruidProcessingConfig druidProcessingConfig = new DruidProcessingConfig(){

            public int getNumThreads() {
                return 2;
            }

            public String getFormatString() {
                return null;
            }
        };
        Supplier configSupplier = Suppliers.ofInstance((Object)config);
        GroupByStrategySelector strategySelector = new GroupByStrategySelector(configSupplier, new GroupByStrategyV1(configSupplier, new GroupByQueryEngine(configSupplier, (NonBlockingPool)bufferPool), NOOP_QUERYWATCHER, (NonBlockingPool)bufferPool), new GroupByStrategyV2(druidProcessingConfig, configSupplier, (NonBlockingPool)bufferPool, (BlockingPool)mergePool, new ObjectMapper((JsonFactory)new SmileFactory()), NOOP_QUERYWATCHER));
        this.groupByFactory = new GroupByQueryRunnerFactory(strategySelector, new GroupByQueryQueryToolChest(strategySelector, GroupByMultiSegmentTest.NoopIntervalChunkingQueryRunnerDecorator()));
    }

    @After
    public void tearDown() throws Exception {
        for (IncrementalIndex incrementalIndex : this.incrementalIndices) {
            incrementalIndex.close();
        }
        for (QueryableIndex queryableIndex : this.groupByIndices) {
            queryableIndex.close();
        }
        if (this.tmpDir != null) {
            FileUtils.deleteDirectory((File)this.tmpDir);
        }
    }

    @Test
    public void testHavingAndNoLimitPushDown() throws Exception {
        QueryToolChest toolChest = this.groupByFactory.getToolchest();
        FinalizeResultsQueryRunner theRunner = new FinalizeResultsQueryRunner(toolChest.mergeResults(this.groupByFactory.mergeRunners(this.executorService, this.makeGroupByMultiRunners())), toolChest);
        MultipleIntervalSegmentSpec intervalSpec = new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.utc((long)0L, (long)1000000L)));
        GroupByQuery query = GroupByQuery.builder().setDataSource("blah").setQuerySegmentSpec((QuerySegmentSpec)intervalSpec).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("dimA", null)})).setAggregatorSpecs(Arrays.asList(new LongSumAggregatorFactory("metA", "metA"))).setLimitSpec((LimitSpec)new DefaultLimitSpec(Arrays.asList(new OrderByColumnSpec("dimA", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(1))).setHavingSpec((HavingSpec)new GreaterThanHavingSpec("metA", (Number)110)).setGranularity(Granularities.ALL).build();
        Sequence queryResult = theRunner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap());
        List results = Sequences.toList((Sequence)queryResult, (List)Lists.newArrayList());
        Row expectedRow = GroupByQueryRunnerTestHelper.createExpectedRow("1970-01-01T00:00:00.000Z", "dimA", "world", "metA", 150L);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)expectedRow, results.get(0));
    }

    private List<QueryRunner<Row>> makeGroupByMultiRunners() {
        ArrayList runners = Lists.newArrayList();
        for (QueryableIndex qindex : this.groupByIndices) {
            QueryRunner<Row> runner = GroupByMultiSegmentTest.makeQueryRunner(this.groupByFactory, qindex.toString(), (Segment)new QueryableIndexSegment(qindex.toString(), qindex));
            runners.add(this.groupByFactory.getToolchest().preMergeQueryDecoration(runner));
        }
        return runners;
    }

    public static <T, QueryType extends Query<T>> QueryRunner<T> makeQueryRunner(QueryRunnerFactory<T, QueryType> factory, String segmentId, Segment adapter) {
        return new FinalizeResultsQueryRunner((QueryRunner)new BySegmentQueryRunner(segmentId, adapter.getDataInterval().getStart(), factory.createRunner(adapter)), factory.getToolchest());
    }

    public static IntervalChunkingQueryRunnerDecorator NoopIntervalChunkingQueryRunnerDecorator() {
        return new IntervalChunkingQueryRunnerDecorator(null, null, null){

            public <T> QueryRunner<T> decorate(final QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> toolChest) {
                return new QueryRunner<T>(){

                    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
                        return delegate.run(queryPlus, responseContext);
                    }
                };
            }
        };
    }

    static {
        JSON_MAPPER = new DefaultObjectMapper();
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class, (Object)ExprMacroTable.nil()));
        INDEX_IO = new IndexIO(JSON_MAPPER, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        INDEX_MERGER_V9 = new IndexMergerV9(JSON_MAPPER, INDEX_IO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        NOOP_QUERYWATCHER = new QueryWatcher(){

            public void registerQuery(Query query, ListenableFuture future) {
            }
        };
    }

    private static class OffheapBufferGenerator
    implements Supplier<ByteBuffer> {
        private static final Logger log = new Logger(OffheapBufferGenerator.class);
        private final String description;
        private final int computationBufferSize;
        private final AtomicLong count = new AtomicLong(0L);

        public OffheapBufferGenerator(String description, int computationBufferSize) {
            this.description = description;
            this.computationBufferSize = computationBufferSize;
        }

        public ByteBuffer get() {
            log.info("Allocating new %s buffer[%,d] of size[%,d]", new Object[]{this.description, this.count.getAndIncrement(), this.computationBufferSize});
            return ByteBuffer.allocateDirect(this.computationBufferSize);
        }
    }
}

