/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SelectorDimFilterTest {
    @Test
    public void testGetCacheKey() {
        SelectorDimFilter selectorDimFilter = new SelectorDimFilter("abc", "d", null);
        SelectorDimFilter selectorDimFilter2 = new SelectorDimFilter("ab", "cd", null);
        Assert.assertFalse((boolean)Arrays.equals(selectorDimFilter.getCacheKey(), selectorDimFilter2.getCacheKey()));
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        SelectorDimFilter selectorDimFilter3 = new SelectorDimFilter("abc", "d", (ExtractionFn)regexFn);
        Assert.assertFalse((boolean)Arrays.equals(selectorDimFilter.getCacheKey(), selectorDimFilter3.getCacheKey()));
    }

    @Test
    public void testToString() {
        SelectorDimFilter selectorDimFilter = new SelectorDimFilter("abc", "d", null);
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        SelectorDimFilter selectorDimFilter2 = new SelectorDimFilter("abc", "d", (ExtractionFn)regexFn);
        Assert.assertEquals((Object)"abc = d", (Object)selectorDimFilter.toString());
        Assert.assertEquals((Object)"regex(/.*/, 1)(abc) = d", (Object)selectorDimFilter2.toString());
    }

    @Test
    public void testHashCode() {
        SelectorDimFilter selectorDimFilter = new SelectorDimFilter("abc", "d", null);
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        SelectorDimFilter selectorDimFilter2 = new SelectorDimFilter("abc", "d", (ExtractionFn)regexFn);
        Assert.assertNotEquals((long)selectorDimFilter.hashCode(), (long)selectorDimFilter2.hashCode());
    }

    @Test
    public void testSimpleOptimize() {
        SelectorDimFilter selectorDimFilter = new SelectorDimFilter("abc", "d", null);
        AndDimFilter filter = new AndDimFilter(Arrays.asList(new OrDimFilter(Arrays.asList(new AndDimFilter(Arrays.asList(selectorDimFilter, null))))));
        Assert.assertEquals((Object)selectorDimFilter, (Object)filter.optimize());
    }
}

