/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.RegexDimExtractionFn;
import io.druid.query.filter.SearchQueryDimFilter;
import io.druid.query.search.SearchQuerySpec;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SearchQueryDimFilterTest {
    @Test
    public void testGetCacheKey() {
        SearchQueryDimFilter searchQueryDimFilter = new SearchQueryDimFilter("dim", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"value");
            }
        }, null);
        SearchQueryDimFilter searchQueryDimFilter2 = new SearchQueryDimFilter("di", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"mvalue");
            }
        }, null);
        Assert.assertFalse((boolean)Arrays.equals(searchQueryDimFilter.getCacheKey(), searchQueryDimFilter2.getCacheKey()));
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        SearchQueryDimFilter searchQueryDimFilter3 = new SearchQueryDimFilter("dim", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"value");
            }
        }, (ExtractionFn)regexFn);
        Assert.assertFalse((boolean)Arrays.equals(searchQueryDimFilter.getCacheKey(), searchQueryDimFilter3.getCacheKey()));
    }

    @Test
    public void testEquals() {
        SearchQueryDimFilter searchQueryDimFilter = new SearchQueryDimFilter("dim", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"value");
            }
        }, null);
        SearchQueryDimFilter searchQueryDimFilter2 = new SearchQueryDimFilter("di", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"mvalue");
            }
        }, null);
        Assert.assertNotEquals((Object)searchQueryDimFilter, (Object)searchQueryDimFilter2);
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        SearchQueryDimFilter searchQueryDimFilter3 = new SearchQueryDimFilter("dim", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"value");
            }
        }, (ExtractionFn)regexFn);
        Assert.assertNotEquals((Object)searchQueryDimFilter, (Object)searchQueryDimFilter3);
    }

    @Test
    public void testHashcode() {
        SearchQueryDimFilter searchQueryDimFilter = new SearchQueryDimFilter("dim", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"value");
            }
        }, null);
        SearchQueryDimFilter searchQueryDimFilter2 = new SearchQueryDimFilter("di", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"mvalue");
            }
        }, null);
        Assert.assertNotEquals((long)searchQueryDimFilter.hashCode(), (long)searchQueryDimFilter2.hashCode());
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        SearchQueryDimFilter searchQueryDimFilter3 = new SearchQueryDimFilter("dim", new SearchQuerySpec(){

            public boolean accept(String dimVal) {
                return false;
            }

            public byte[] getCacheKey() {
                return StringUtils.toUtf8((String)"value");
            }
        }, (ExtractionFn)regexFn);
        Assert.assertNotEquals((long)searchQueryDimFilter.hashCode(), (long)searchQueryDimFilter3.hashCode());
    }
}

