/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.extraction.SubstringDimExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.LikeDimFilter;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class LikeDimFilterTest {
    @Test
    public void testSerde() throws IOException {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        DimFilter filter2 = (DimFilter)objectMapper.readValue(objectMapper.writeValueAsString((Object)filter), DimFilter.class);
        Assert.assertEquals((Object)filter, (Object)filter2);
    }

    @Test
    public void testGetCacheKey() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter2 = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter3 = new LikeDimFilter("foo", "bar%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertArrayEquals((byte[])filter.getCacheKey(), (byte[])filter2.getCacheKey());
        Assert.assertFalse((boolean)Arrays.equals(filter.getCacheKey(), filter3.getCacheKey()));
    }

    @Test
    public void testEqualsAndHashCode() {
        LikeDimFilter filter = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter2 = new LikeDimFilter("foo", "bar%", "@", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        LikeDimFilter filter3 = new LikeDimFilter("foo", "bar%", null, (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(2)));
        Assert.assertEquals((Object)filter, (Object)filter2);
        Assert.assertNotEquals((Object)filter, (Object)filter3);
        Assert.assertEquals((long)filter.hashCode(), (long)filter2.hashCode());
        Assert.assertNotEquals((long)filter.hashCode(), (long)filter3.hashCode());
    }
}

