/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Key;
import io.druid.guice.GuiceInjectors;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.StringUtils;
import io.druid.query.extraction.DimExtractionFn;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class MapLookupExtractionFnSerDeTest {
    private static ObjectMapper mapper;
    private static final Map<String, String> renames;

    @BeforeClass
    public static void setup() throws JsonProcessingException {
        Injector defaultInjector = GuiceInjectors.makeStartupInjector();
        mapper = (ObjectMapper)defaultInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    @Test
    public void testDeserialization() throws IOException {
        DimExtractionFn fn = (DimExtractionFn)mapper.reader(DimExtractionFn.class).readValue(StringUtils.format((String)"{\"type\":\"lookup\",\"lookup\":{\"type\":\"map\", \"map\":%s}}", (Object[])new Object[]{mapper.writeValueAsString(renames)}));
        for (String key : renames.keySet()) {
            Assert.assertEquals((Object)renames.get(key), (Object)fn.apply(key));
        }
        String crazyString = UUID.randomUUID().toString();
        Assert.assertEquals(null, (Object)fn.apply(crazyString));
        Assert.assertEquals((Object)crazyString, (Object)((DimExtractionFn)mapper.reader(DimExtractionFn.class).readValue(StringUtils.format((String)"{\"type\":\"lookup\",\"lookup\":{\"type\":\"map\", \"map\":%s}, \"retainMissingValue\":true}", (Object[])new Object[]{mapper.writeValueAsString(renames)}))).apply(crazyString));
    }

    static {
        renames = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"bar", (Object)"baz");
    }
}

