/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.RegexFilteredDimensionSpec;
import io.druid.query.dimension.TestDimensionSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.TestHelper;
import io.druid.segment.data.IndexedInts;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class RegexFilteredDimensionSpecTest {
    @Test
    public void testSerde() throws Exception {
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        String jsonStr = "{\n  \"type\": \"regexFiltered\",\n  \"delegate\": {\n    \"type\": \"default\",\n    \"dimension\": \"foo\",\n    \"outputName\": \"bar\"\n  },\n  \"pattern\": \"xxx\"\n}";
        RegexFilteredDimensionSpec actual = (RegexFilteredDimensionSpec)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, DimensionSpec.class)), DimensionSpec.class);
        RegexFilteredDimensionSpec expected = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "xxx");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetCacheKey() {
        RegexFilteredDimensionSpec spec1 = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "xxx");
        RegexFilteredDimensionSpec spec2 = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "xyz");
        Assert.assertFalse((boolean)Arrays.equals(spec1.getCacheKey(), spec2.getCacheKey()));
    }

    @Test
    public void testDecorator() {
        RegexFilteredDimensionSpec spec = new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("foo", "bar"), "[c,g]");
        DimensionSelector selector = spec.decorate((DimensionSelector)TestDimensionSelector.instance);
        Assert.assertEquals((long)2L, (long)selector.getValueCardinality());
        IndexedInts row = selector.getRow();
        Assert.assertEquals((long)2L, (long)row.size());
        Assert.assertEquals((long)0L, (long)row.get(0));
        Assert.assertEquals((long)1L, (long)row.get(1));
        Assert.assertEquals((Object)"c", (Object)selector.lookupName(0));
        Assert.assertEquals((Object)"g", (Object)selector.lookupName(1));
        Assert.assertEquals((long)0L, (long)selector.idLookup().lookupId("c"));
        Assert.assertEquals((long)1L, (long)selector.idLookup().lookupId("g"));
    }
}

