/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.google.common.collect.Lists;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.jackson.AggregatorsModule;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.aggregation.AggregationTestHelper;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryRunnerTest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HyperUniquesAggregationTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final GroupByQueryConfig config;

    public HyperUniquesAggregationTest(GroupByQueryConfig config) {
        this.config = config;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList constructors = Lists.newArrayList();
        for (GroupByQueryConfig config : GroupByQueryRunnerTest.testConfigs()) {
            constructors.add(new Object[]{config});
        }
        return constructors;
    }

    @Test
    public void testIngestAndQuery() throws Exception {
        AggregationTestHelper helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Lists.newArrayList((Object[])new AggregatorsModule[]{new AggregatorsModule()}), this.config, this.tempFolder);
        String metricSpec = "[{\"type\": \"hyperUnique\",\"name\": \"index_hll\",\"fieldName\": \"market\"}]";
        String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"quality\", \"placement\", \"placementish\", \"index\"]  }}";
        String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"index_hll\", \"fieldName\": \"index_hll\" }],\"postAggregations\": [  { \"type\": \"hyperUniqueCardinality\", \"name\": \"index_unique_count\", \"fieldName\": \"index_hll\" }],\"intervals\": [ \"1970/2050\" ]}";
        Sequence<Row> seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.sample.tsv").getFile()), parseSpec, metricSpec, 0L, Granularities.NONE, 50000, query);
        MapBasedRow row = (MapBasedRow)((ArrayList)Sequences.toList(seq, (List)Lists.newArrayList())).get(0);
        Assert.assertEquals((double)3.0, (double)row.getMetric("index_hll").floatValue(), (double)0.1);
        Assert.assertEquals((double)3.0, (double)row.getMetric("index_unique_count").floatValue(), (double)0.1);
    }

    @Test
    public void testIngestAndQueryPrecomputedHll() throws Exception {
        AggregationTestHelper helper = AggregationTestHelper.createGroupByQueryAggregationTestHelper(Lists.newArrayList((Object[])new AggregatorsModule[]{new AggregatorsModule()}), this.config, this.tempFolder);
        String metricSpec = "[{\"type\": \"hyperUnique\",\"name\": \"index_hll\",\"fieldName\": \"preComputedHll\",\"isInputHyperUnique\": true}]";
        String parseSpec = "{\"type\" : \"string\",\"parseSpec\" : {    \"format\" : \"tsv\",    \"timestampSpec\" : {        \"column\" : \"timestamp\",        \"format\" : \"auto\"},    \"dimensionsSpec\" : {        \"dimensions\": [],        \"dimensionExclusions\" : [],        \"spatialDimensions\" : []    },    \"columns\": [\"timestamp\", \"market\", \"preComputedHll\"]  }}";
        String query = "{\"queryType\": \"groupBy\",\"dataSource\": \"test_datasource\",\"granularity\": \"ALL\",\"dimensions\": [],\"aggregations\": [  { \"type\": \"hyperUnique\", \"name\": \"index_hll\", \"fieldName\": \"index_hll\" }],\"postAggregations\": [  { \"type\": \"hyperUniqueCardinality\", \"name\": \"index_unique_count\", \"fieldName\": \"index_hll\" }],\"intervals\": [ \"1970/2050\" ]}";
        Sequence<Row> seq = helper.createIndexAndRunQueryOnSegment(new File(this.getClass().getClassLoader().getResource("druid.hll.sample.tsv").getFile()), parseSpec, metricSpec, 0L, Granularities.DAY, 50000, query);
        MapBasedRow row = (MapBasedRow)((ArrayList)Sequences.toList(seq, (List)Lists.newArrayList())).get(0);
        Assert.assertEquals((double)4.0, (double)row.getMetric("index_hll").floatValue(), (double)0.1);
        Assert.assertEquals((double)4.0, (double)row.getMetric("index_unique_count").floatValue(), (double)0.1);
    }
}

