/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.hll.HyperLogLogCollector;
import io.druid.java.util.common.StringUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.LongMinAggregator;
import io.druid.query.aggregation.LongMinAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregator;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.aggregation.MetricManipulatorFns;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.segment.BaseLongColumnValueSelector;
import io.druid.segment.TestLongColumnSelector;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MetricManipulatorFnsTest {
    private static final String NAME = "name";
    private static final String FIELD = "field";
    private final AggregatorFactory aggregatorFactory;
    private final Object agg;
    private final Object identity;
    private final Object finalize;
    private final Object serialForm;
    private final Object deserForm;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        ArrayList<Object[]> constructorArrays = new ArrayList<Object[]>();
        long longVal = 13789L;
        LongMinAggregator longMinAggregator = new LongMinAggregator((BaseLongColumnValueSelector)new TestLongColumnSelector(){

            public long getLong() {
                return 13789L;
            }
        });
        LongMinAggregatorFactory longMinAggregatorFactory = new LongMinAggregatorFactory(NAME, FIELD);
        constructorArrays.add(new Object[]{longMinAggregatorFactory, longMinAggregator, longMinAggregator, longMinAggregator, 13789L, 13789L});
        HyperUniquesAggregatorFactory hyperUniquesAggregatorFactory = new HyperUniquesAggregatorFactory(NAME, FIELD);
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        collector.add((short)1, (byte)5);
        constructorArrays.add(new Object[]{hyperUniquesAggregatorFactory, collector, collector, collector.estimateCardinality(), collector.toByteArray(), collector});
        LongSumAggregatorFactory longSumAggregatorFactory = new LongSumAggregatorFactory(NAME, FIELD);
        LongSumAggregator longSumAggregator = new LongSumAggregator((BaseLongColumnValueSelector)new TestLongColumnSelector(){

            public long getLong() {
                return 13789L;
            }
        });
        constructorArrays.add(new Object[]{longSumAggregatorFactory, longSumAggregator, longSumAggregator, longSumAggregator, 13789L, 13789L});
        for (Object[] argList : constructorArrays) {
            Assert.assertEquals((String)StringUtils.format((String)"Arglist %s is too short. Expected 6 found %d", (Object[])new Object[]{Arrays.toString(argList), argList.length}), (long)6L, (long)argList.length);
        }
        return constructorArrays;
    }

    public MetricManipulatorFnsTest(AggregatorFactory aggregatorFactory, Object agg, Object identity, Object finalize, Object serialForm, Object deserForm) {
        this.aggregatorFactory = aggregatorFactory;
        this.agg = agg;
        this.identity = identity;
        this.finalize = finalize;
        this.serialForm = serialForm;
        this.deserForm = deserForm;
    }

    @Test
    public void testIdentity() {
        Assert.assertEquals((Object)this.identity, (Object)this.agg);
        Assert.assertEquals((Object)this.identity, (Object)MetricManipulatorFns.identity().manipulate(this.aggregatorFactory, this.agg));
    }

    @Test
    public void testFinalize() {
        Assert.assertEquals((Object)this.identity, (Object)this.agg);
        Assert.assertEquals((Object)this.finalize, (Object)MetricManipulatorFns.finalizing().manipulate(this.aggregatorFactory, this.agg));
    }

    @Test
    public void testDeserialize() {
        Assert.assertEquals((Object)this.identity, (Object)this.agg);
        Assert.assertEquals((Object)this.deserForm, (Object)MetricManipulatorFns.deserializing().manipulate(this.aggregatorFactory, this.serialForm));
    }
}

