/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.druid.java.util.common.StringUtils;
import io.druid.js.JavaScriptConfig;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.query.aggregation.JavaScriptAggregator;
import io.druid.query.aggregation.JavaScriptAggregatorBenchmark;
import io.druid.query.aggregation.JavaScriptAggregatorFactory;
import io.druid.query.aggregation.JavaScriptBufferAggregator;
import io.druid.query.aggregation.TestDoubleColumnSelectorImpl;
import io.druid.query.aggregation.TestFloatColumnSelector;
import io.druid.query.aggregation.TestObjectColumnSelector;
import io.druid.query.dimension.DimensionSpec;
import io.druid.segment.BaseDoubleColumnValueSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.column.ColumnCapabilities;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptAggregatorTest {
    protected static final Map<String, String> sumLogATimesBPlusTen = Maps.newHashMap();
    protected static final Map<String, String> scriptDoubleSum = Maps.newHashMap();
    final ColumnSelectorFactory DUMMY_COLUMN_SELECTOR_FACTORY = new ColumnSelectorFactory(){

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return null;
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            return null;
        }

        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return null;
        }
    };
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    private static void aggregate(TestDoubleColumnSelectorImpl selector1, TestDoubleColumnSelectorImpl selector2, Aggregator agg) {
        agg.aggregate();
        selector1.increment();
        selector2.increment();
    }

    private void aggregateBuffer(TestFloatColumnSelector selector1, TestFloatColumnSelector selector2, BufferAggregator agg, ByteBuffer buf, int position) {
        agg.aggregate(buf, position);
        selector1.increment();
        selector2.increment();
    }

    private static void aggregate(TestDoubleColumnSelectorImpl selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    private static void aggregate(TestObjectColumnSelector selector, Aggregator agg) {
        agg.aggregate();
        selector.increment();
    }

    @Test
    public void testAggregate() {
        TestDoubleColumnSelectorImpl selector1 = new TestDoubleColumnSelectorImpl(new double[]{42.12, 9.0});
        TestDoubleColumnSelectorImpl selector2 = new TestDoubleColumnSelectorImpl(new double[]{2.0, 3.0});
        Map<String, String> script = sumLogATimesBPlusTen;
        JavaScriptAggregator agg = new JavaScriptAggregator(Arrays.asList(selector1, selector2), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        double val = 10.0;
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(selector1, selector2, (Aggregator)agg);
        Assert.assertEquals((Object)(val += Math.log(42.12) * 2.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(selector1, selector2, (Aggregator)agg);
        Assert.assertEquals((Object)(val += Math.log(9.0) * 3.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
    }

    @Test
    public void testBufferAggregate() {
        TestFloatColumnSelector selector1 = new TestFloatColumnSelector(new float[]{42.12f, 9.0f});
        TestFloatColumnSelector selector2 = new TestFloatColumnSelector(new float[]{2.0f, 3.0f});
        Map<String, String> script = sumLogATimesBPlusTen;
        JavaScriptBufferAggregator agg = new JavaScriptBufferAggregator(Arrays.asList(selector1, selector2), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        ByteBuffer buf = ByteBuffer.allocateDirect(32);
        int position = 4;
        agg.init(buf, 4);
        double val = 10.0;
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        this.aggregateBuffer(selector1, selector2, (BufferAggregator)agg, buf, 4);
        Assert.assertEquals((Object)(val += Math.log(42.12f) * 2.0), (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        this.aggregateBuffer(selector1, selector2, (BufferAggregator)agg, buf, 4);
        Assert.assertEquals((Object)(val += Math.log(9.0) * 3.0), (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
        Assert.assertEquals((Object)val, (Object)agg.get(buf, 4));
    }

    @Test
    public void testAggregateMissingColumn() {
        Map<String, String> script = scriptDoubleSum;
        JavaScriptAggregator agg = new JavaScriptAggregator(Collections.singletonList(null), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        double val = 0.0;
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        agg.aggregate();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        agg.aggregate();
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
        Assert.assertEquals((Object)0.0, (Object)agg.get());
    }

    @Test
    public void testAggregateStrings() {
        TestObjectColumnSelector<Object> ocs = new TestObjectColumnSelector<Object>(new Object[]{"what", null, new String[]{"hey", "there"}});
        JavaScriptAggregator agg = new JavaScriptAggregator(Collections.singletonList(ocs), JavaScriptAggregatorFactory.compileScript((String)"function aggregate(current, a) { if (Array.isArray(a)) { return current + a.length; } else if (typeof a === 'string') { return current + 1; } else { return current; } }", (String)scriptDoubleSum.get("fnReset"), (String)scriptDoubleSum.get("fnCombine")));
        double val = 0.0;
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)(val += 1.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        JavaScriptAggregatorTest.aggregate(ocs, (Aggregator)agg);
        Assert.assertEquals((Object)(val += 2.0), (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
        Assert.assertEquals((Object)val, (Object)agg.get());
    }

    @Test
    public void testJavaScriptDisabledFactorize() {
        JavaScriptAggregatorFactory factory = new JavaScriptAggregatorFactory("foo", (List)ImmutableList.of((Object)"foo"), scriptDoubleSum.get("fnAggregate"), scriptDoubleSum.get("fnReset"), scriptDoubleSum.get("fnCombine"), new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        factory.factorize(this.DUMMY_COLUMN_SELECTOR_FACTORY);
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testJavaScriptDisabledFactorizeBuffered() {
        JavaScriptAggregatorFactory factory = new JavaScriptAggregatorFactory("foo", (List)ImmutableList.of((Object)"foo"), scriptDoubleSum.get("fnAggregate"), scriptDoubleSum.get("fnReset"), scriptDoubleSum.get("fnCombine"), new JavaScriptConfig(false));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        factory.factorizeBuffered(this.DUMMY_COLUMN_SELECTOR_FACTORY);
        Assert.assertTrue((boolean)false);
    }

    public static void main(String ... args) throws Exception {
        int i;
        JavaScriptAggregatorBenchmark.LoopingDoubleColumnSelector selector = new JavaScriptAggregatorBenchmark.LoopingDoubleColumnSelector(new double[]{42.12, 9.0});
        Map<String, String> script = scriptDoubleSum;
        JavaScriptAggregator aggRhino = new JavaScriptAggregator(Collections.singletonList(selector), JavaScriptAggregatorFactory.compileScript((String)script.get("fnAggregate"), (String)script.get("fnReset"), (String)script.get("fnCombine")));
        DoubleSumAggregator doubleAgg = new DoubleSumAggregator((BaseDoubleColumnValueSelector)selector);
        long t = 0L;
        for (i = 0; i < 10000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)aggRhino);
        }
        for (i = 0; i < 10000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)doubleAgg);
        }
        t = System.currentTimeMillis();
        for (i = 0; i < 500000000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)aggRhino);
        }
        long t1 = System.currentTimeMillis() - t;
        System.out.println(StringUtils.format((String)"JavaScript aggregator == %,f: %d ms", (Object[])new Object[]{Float.valueOf(aggRhino.getFloat()), t1}));
        t = System.currentTimeMillis();
        for (i = 0; i < 500000000; ++i) {
            JavaScriptAggregatorTest.aggregate(selector, (Aggregator)doubleAgg);
        }
        long t2 = System.currentTimeMillis() - t;
        System.out.println(StringUtils.format((String)"DoubleSum  aggregator == %,f: %d ms", (Object[])new Object[]{Float.valueOf(doubleAgg.getFloat()), t2}));
        System.out.println(StringUtils.format((String)"JavaScript is %2.1fx slower", (Object[])new Object[]{(double)t1 / (double)t2}));
    }

    static {
        sumLogATimesBPlusTen.put("fnAggregate", "function aggregate(current, a, b) { return current + (Math.log(a) * b) }");
        sumLogATimesBPlusTen.put("fnReset", "function reset()                  { return 10 }");
        sumLogATimesBPlusTen.put("fnCombine", "function combine(a,b)             { return a + b }");
        scriptDoubleSum.put("fnAggregate", "function aggregate(current, a) { return current + a }");
        scriptDoubleSum.put("fnReset", "function reset()               { return 0 }");
        scriptDoubleSum.put("fnCombine", "function combine(a,b)          { return a + b }");
    }
}

