/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import java.io.IOException;
import java.util.Arrays;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ResultGranularTimestampComparatorTest {
    private final boolean descending;
    private final DateTime time = DateTimes.of((String)"2011-11-11");

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.transformToConstructionFeeder(Arrays.asList(false, true));
    }

    public ResultGranularTimestampComparatorTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testCompareAll() {
        Result r1 = new Result(this.time, null);
        Result r2 = new Result(this.time.plusYears(5), null);
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)Granularities.ALL, (boolean)this.descending).compare((Object)r1, (Object)r2), (long)0L);
    }

    @Test
    public void testCompareDay() {
        Result res = new Result(this.time, null);
        Result same = new Result(this.time.plusHours(12), null);
        Result greater = new Result(this.time.plusHours(25), null);
        Result less = new Result(this.time.minusHours(1), null);
        Granularity day = Granularities.DAY;
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)day, (boolean)this.descending).compare((Object)res, (Object)same), (long)0L);
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)day, (boolean)this.descending).compare((Object)res, (Object)greater), (long)(this.descending ? 1L : -1L));
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)day, (boolean)this.descending).compare((Object)res, (Object)less), (long)(this.descending ? -1L : 1L));
    }

    @Test
    public void testCompareHour() {
        Result res = new Result(this.time, null);
        Result same = new Result(this.time.plusMinutes(55), null);
        Result greater = new Result(this.time.plusHours(1), null);
        Result less = new Result(this.time.minusHours(1), null);
        Granularity hour = Granularities.HOUR;
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)hour, (boolean)this.descending).compare((Object)res, (Object)same), (long)0L);
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)hour, (boolean)this.descending).compare((Object)res, (Object)greater), (long)(this.descending ? 1L : -1L));
        Assert.assertEquals((long)ResultGranularTimestampComparator.create((Granularity)hour, (boolean)this.descending).compare((Object)res, (Object)less), (long)(this.descending ? -1L : 1L));
    }
}

