/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.Intervals;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.TableDataSource;
import io.druid.query.TestQuery;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryContextsTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testDefaultQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap());
        Assert.assertEquals((long)300000L, (long)QueryContexts.getDefaultTimeout((Query)query));
    }

    @Test
    public void testEmptyQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap());
        Assert.assertEquals((long)300000L, (long)QueryContexts.getTimeout((Query)query));
        query = QueryContexts.withDefaultTimeout((Query)query, (long)60000L);
        Assert.assertEquals((long)60000L, (long)QueryContexts.getTimeout((Query)query));
    }

    @Test
    public void testQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"timeout", (Object)1000));
        Assert.assertEquals((long)1000L, (long)QueryContexts.getTimeout((Query)query));
        query = QueryContexts.withDefaultTimeout((Query)query, (long)1000000L);
        Assert.assertEquals((long)1000L, (long)QueryContexts.getTimeout((Query)query));
    }

    @Test
    public void testQueryMaxTimeout() {
        this.exception.expect(IAE.class);
        this.exception.expectMessage("configured [timeout = 1000] is more than enforced limit of maxQueryTimeout [100].");
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"timeout", (Object)1000));
        QueryContexts.verifyMaxQueryTimeout((Query)query, (long)100L);
    }

    @Test
    public void testMaxScatterGatherBytes() {
        this.exception.expect(IAE.class);
        this.exception.expectMessage("configured [maxScatterGatherBytes = 1000] is more than enforced limit of [100].");
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"maxScatterGatherBytes", (Object)1000));
        QueryContexts.withMaxScatterGatherBytes((Query)query, (long)100L);
    }
}

