/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.Druids;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class IntervalChunkingQueryRunnerTest {
    private IntervalChunkingQueryRunnerDecorator decorator;
    private ExecutorService executors;
    private QueryRunner baseRunner;
    private QueryToolChest toolChest;
    private final Druids.TimeseriesQueryBuilder queryBuilder = Druids.newTimeseriesQueryBuilder().dataSource("test").aggregators((List)Lists.newArrayList((Object[])new AggregatorFactory[]{new CountAggregatorFactory("count")}));

    @Before
    public void setup() {
        this.executors = (ExecutorService)EasyMock.createMock(ExecutorService.class);
        ServiceEmitter emitter = (ServiceEmitter)EasyMock.createNiceMock(ServiceEmitter.class);
        this.decorator = new IntervalChunkingQueryRunnerDecorator(this.executors, QueryRunnerTestHelper.NOOP_QUERYWATCHER, emitter);
        this.baseRunner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        this.toolChest = (QueryToolChest)EasyMock.createNiceMock(QueryToolChest.class);
    }

    @Test
    public void testDefaultNoChunking() {
        QueryPlus queryPlus = QueryPlus.wrap((Query)this.queryBuilder.intervals("2014/2016").build());
        EasyMock.expect((Object)this.baseRunner.run(queryPlus, Collections.EMPTY_MAP)).andReturn((Object)Sequences.empty());
        EasyMock.replay((Object[])new Object[]{this.baseRunner});
        QueryRunner runner = this.decorator.decorate(this.baseRunner, this.toolChest);
        runner.run(queryPlus, Collections.EMPTY_MAP);
        EasyMock.verify((Object[])new Object[]{this.baseRunner});
    }

    @Test
    public void testChunking() {
        TimeseriesQuery query = this.queryBuilder.intervals("2015-01-01T00:00:00.000/2015-01-11T00:00:00.000").context((Map)ImmutableMap.of((Object)"chunkPeriod", (Object)"P1D")).build();
        this.executors.execute((Runnable)EasyMock.anyObject(Runnable.class));
        EasyMock.expectLastCall().times(10);
        EasyMock.replay((Object[])new Object[]{this.executors});
        EasyMock.replay((Object[])new Object[]{this.toolChest});
        QueryRunner runner = this.decorator.decorate(this.baseRunner, this.toolChest);
        runner.run(QueryPlus.wrap((Query)query), Collections.EMPTY_MAP);
        EasyMock.verify((Object[])new Object[]{this.executors});
    }

    @Test
    public void testChunkingOnMonths() {
        TimeseriesQuery query = this.queryBuilder.intervals("2015-01-01T00:00:00.000/2015-02-11T00:00:00.000").context((Map)ImmutableMap.of((Object)"chunkPeriod", (Object)"P1M")).build();
        this.executors.execute((Runnable)EasyMock.anyObject(Runnable.class));
        EasyMock.expectLastCall().times(2);
        EasyMock.replay((Object[])new Object[]{this.executors});
        EasyMock.replay((Object[])new Object[]{this.toolChest});
        QueryRunner runner = this.decorator.decorate(this.baseRunner, this.toolChest);
        runner.run(QueryPlus.wrap((Query)query), Collections.EMPTY_MAP);
        EasyMock.verify((Object[])new Object[]{this.executors});
    }
}

