/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import io.druid.collections.bitmap.BitmapBenchmark;
import io.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import io.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import io.druid.collections.test.annotation.Benchmark;
import io.druid.extendedset.intset.ConciseSet;
import io.druid.extendedset.intset.ImmutableConciseSet;
import io.druid.java.util.common.StringUtils;
import java.util.BitSet;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

@Category(value={Benchmark.class})
@BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20)
public class UniformBitmapBenchmarkTest
extends BitmapBenchmark {
    public static final double DENSITY = 0.01;
    public static final int MIN_INTERSECT = 50;

    @BeforeClass
    public static void prepareMostlyUniform() throws Exception {
        int i;
        System.setProperty("jub.customkey", StringUtils.format((String)"%05.4f", (Object[])new Object[]{0.01}));
        UniformBitmapBenchmarkTest.reset();
        BitSet expectedUnion = new BitSet();
        int[] knownTrue = new int[50];
        for (i = 0; i < knownTrue.length; ++i) {
            knownTrue[i] = rand.nextInt(500000);
        }
        for (i = 0; i < 10000; ++i) {
            ConciseSet c = new ConciseSet();
            MutableRoaringBitmap r = new MutableRoaringBitmap();
            for (int k = 0; k < 500000; ++k) {
                if (!(rand.nextDouble() < 0.01)) continue;
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
            }
            for (int k : knownTrue) {
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
            }
            UniformBitmapBenchmarkTest.concise[i] = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)c);
            UniformBitmapBenchmarkTest.offheapConcise[i] = UniformBitmapBenchmarkTest.makeOffheapConcise(concise[i]);
            UniformBitmapBenchmarkTest.roaring[i] = r;
            UniformBitmapBenchmarkTest.immutableRoaring[i] = UniformBitmapBenchmarkTest.makeImmutableRoaring(r);
            UniformBitmapBenchmarkTest.offheapRoaring[i] = UniformBitmapBenchmarkTest.makeOffheapRoaring(r);
            UniformBitmapBenchmarkTest.genericConcise[i] = new WrappedImmutableConciseBitmap(offheapConcise[i]);
            UniformBitmapBenchmarkTest.genericRoaring[i] = new WrappedImmutableRoaringBitmap(offheapRoaring[i]);
        }
        unionCount = expectedUnion.cardinality();
        minIntersection = knownTrue.length;
        UniformBitmapBenchmarkTest.printSizeStats(0.01, "Uniform Bitmap");
    }
}

