/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.Clock;
import com.google.common.collect.Lists;
import io.druid.collections.bitmap.ConciseBitmapFactory;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.bitmap.RoaringBitmapFactory;
import io.druid.extendedset.intset.ImmutableConciseSet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Random;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

@BenchmarkOptions(clock=Clock.NANO_TIME, benchmarkRounds=50)
public class BitmapBenchmark {
    public static final int LENGTH = 500000;
    public static final int SIZE = 10000;
    static final ImmutableConciseSet[] concise = new ImmutableConciseSet[10000];
    static final ImmutableConciseSet[] offheapConcise = new ImmutableConciseSet[10000];
    static final ImmutableRoaringBitmap[] roaring = new ImmutableRoaringBitmap[10000];
    static final ImmutableRoaringBitmap[] immutableRoaring = new ImmutableRoaringBitmap[10000];
    static final ImmutableRoaringBitmap[] offheapRoaring = new ImmutableRoaringBitmap[10000];
    static final ImmutableBitmap[] genericConcise = new ImmutableBitmap[10000];
    static final ImmutableBitmap[] genericRoaring = new ImmutableBitmap[10000];
    static final ConciseBitmapFactory conciseFactory = new ConciseBitmapFactory();
    static final RoaringBitmapFactory roaringFactory = new RoaringBitmapFactory();
    static Random rand = new Random(0L);
    static long totalConciseBytes = 0L;
    static long totalRoaringBytes = 0L;
    static long conciseCount = 0L;
    static long roaringCount = 0L;
    static long unionCount = 0L;
    static long minIntersection = 0L;
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();

    protected static ImmutableConciseSet makeOffheapConcise(ImmutableConciseSet concise) {
        byte[] bytes = concise.toBytes();
        totalConciseBytes += (long)bytes.length;
        ++conciseCount;
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes.length).put(bytes);
        buf.rewind();
        return new ImmutableConciseSet(buf);
    }

    protected static ImmutableRoaringBitmap writeImmutable(MutableRoaringBitmap r, ByteBuffer buf) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        r.serialize((DataOutput)new DataOutputStream(out));
        byte[] bytes = out.toByteArray();
        Assert.assertEquals((long)buf.remaining(), (long)bytes.length);
        buf.put(bytes);
        buf.rewind();
        return new ImmutableRoaringBitmap(buf.asReadOnlyBuffer());
    }

    protected static void reset() {
        conciseCount = 0L;
        roaringCount = 0L;
        totalConciseBytes = 0L;
        totalRoaringBytes = 0L;
        unionCount = 0L;
        minIntersection = 0L;
        rand = new Random(0L);
    }

    protected static void printSizeStats(double density, String name) {
        System.out.println("");
        System.out.println("## " + name);
        System.out.println("");
        System.out.printf(Locale.ENGLISH, " d = %06.5f | Concise | Roaring%n", density);
        System.out.println("-------------|---------|---------");
        System.out.printf(Locale.ENGLISH, "Count        |   %5d |   %5d %n", conciseCount, roaringCount);
        System.out.printf(Locale.ENGLISH, "Average size |   %5d |   %5d %n", totalConciseBytes / conciseCount, totalRoaringBytes / roaringCount);
        System.out.println("-------------|---------|---------");
        System.out.println("");
        System.out.flush();
    }

    protected static ImmutableRoaringBitmap makeOffheapRoaring(MutableRoaringBitmap r) throws IOException {
        int size = r.serializedSizeInBytes();
        ByteBuffer buf = ByteBuffer.allocateDirect(size);
        totalRoaringBytes += (long)size;
        ++roaringCount;
        return BitmapBenchmark.writeImmutable(r, buf);
    }

    protected static ImmutableRoaringBitmap makeImmutableRoaring(MutableRoaringBitmap r) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(r.serializedSizeInBytes());
        return BitmapBenchmark.writeImmutable(r, buf);
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=2)
    public void timeConciseUnion() throws Exception {
        ImmutableConciseSet union = ImmutableConciseSet.union((ImmutableConciseSet[])concise);
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=2)
    public void timeOffheapConciseUnion() throws Exception {
        ImmutableConciseSet union = ImmutableConciseSet.union((ImmutableConciseSet[])offheapConcise);
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=2)
    public void timeGenericConciseUnion() throws Exception {
        ImmutableBitmap union = conciseFactory.union((Iterable)Lists.newArrayList((Object[])genericConcise));
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=5)
    public void timeGenericConciseIntersection() throws Exception {
        ImmutableBitmap intersection = conciseFactory.intersection((Iterable)Lists.newArrayList((Object[])genericConcise));
        Assert.assertTrue(((long)intersection.size() >= minIntersection ? 1 : 0) != 0);
    }

    @Test
    public void timeRoaringUnion() throws Exception {
        MutableRoaringBitmap union = BufferFastAggregation.horizontal_or(Lists.newArrayList((Object[])roaring).iterator());
        Assert.assertEquals((long)unionCount, (long)union.getCardinality());
    }

    @Test
    public void timeImmutableRoaringUnion() throws Exception {
        MutableRoaringBitmap union = BufferFastAggregation.horizontal_or(Lists.newArrayList((Object[])immutableRoaring).iterator());
        Assert.assertEquals((long)unionCount, (long)union.getCardinality());
    }

    @Test
    public void timeOffheapRoaringUnion() throws Exception {
        MutableRoaringBitmap union = BufferFastAggregation.horizontal_or(Lists.newArrayList((Object[])offheapRoaring).iterator());
        Assert.assertEquals((long)unionCount, (long)union.getCardinality());
    }

    @Test
    public void timeGenericRoaringUnion() throws Exception {
        ImmutableBitmap union = roaringFactory.union((Iterable)Lists.newArrayList((Object[])genericRoaring));
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    public void timeGenericRoaringIntersection() throws Exception {
        ImmutableBitmap intersection = roaringFactory.intersection((Iterable)Lists.newArrayList((Object[])genericRoaring));
        Assert.assertTrue(((long)intersection.size() >= minIntersection ? 1 : 0) != 0);
    }
}

