/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.collections.IntSetTestUtility;
import io.druid.collections.IntegerSet;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.collections.bitmap.WrappedBitSetBitmap;
import io.druid.collections.bitmap.WrappedConciseBitmap;
import io.druid.collections.bitmap.WrappedRoaringBitmap;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TestIntegerSet {
    private static Iterable<Class<? extends MutableBitmap>> clazzes = Lists.newArrayList((Object[])new Class[]{WrappedBitSetBitmap.class, WrappedConciseBitmap.class, WrappedRoaringBitmap.class});

    @Test
    public void testSimpleSet() {
        WrappedBitSetBitmap wrappedBitSetBitmapBitSet = new WrappedBitSetBitmap();
        IntSetTestUtility.addAllToMutable((MutableBitmap)wrappedBitSetBitmapBitSet, IntSetTestUtility.getSetBits());
        IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitSetBitmapBitSet);
        Assert.assertTrue((boolean)Sets.difference((Set)integerSet, IntSetTestUtility.getSetBits()).isEmpty());
    }

    @Test
    public void testSimpleAdd() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Set<Integer> set = IntSetTestUtility.getSetBits();
            set.add(999);
            integerSet.add(Integer.valueOf(999));
            Assert.assertTrue((boolean)Sets.difference((Set)integerSet, set).isEmpty());
            integerSet.add(Integer.valueOf(58577));
            Assert.assertFalse((boolean)Sets.difference((Set)integerSet, set).isEmpty());
        }
    }

    @Test
    public void testContainsAll() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Set<Integer> set = IntSetTestUtility.getSetBits();
            Assert.assertTrue((boolean)integerSet.containsAll(set));
            set.add(999);
            Assert.assertFalse((boolean)integerSet.containsAll(set));
        }
    }

    @Test
    public void testRemoveEverything() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Set<Integer> set = IntSetTestUtility.getSetBits();
            integerSet.removeAll(set);
            boolean isEmpty = integerSet.isEmpty();
            Assert.assertTrue((boolean)isEmpty);
        }
    }

    @Test
    public void testRemoveOneThing() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Set<Integer> set = IntSetTestUtility.getSetBits();
            integerSet.remove((Object)1);
            set.remove(1);
            Assert.assertTrue((boolean)Sets.difference(set, (Set)integerSet).isEmpty());
        }
    }

    @Test
    public void testIsEmpty() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Assert.assertFalse((boolean)integerSet.isEmpty());
            integerSet.clear();
            Assert.assertTrue((boolean)integerSet.isEmpty());
            integerSet.add(Integer.valueOf(1));
            Assert.assertFalse((boolean)integerSet.isEmpty());
        }
    }

    @Test
    public void testSize() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Set<Integer> set = IntSetTestUtility.getSetBits();
            Assert.assertEquals((long)set.size(), (long)integerSet.size());
        }
    }

    @Test
    public void testRetainAll() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Set<Integer> set = IntSetTestUtility.getSetBits();
            set.remove(1);
            set.add(9999);
            boolean threwError = false;
            try {
                integerSet.retainAll(set);
            }
            catch (UnsupportedOperationException ex) {
                threwError = true;
            }
            Assert.assertTrue((boolean)threwError);
        }
    }

    @Test
    public void testIntOverflow() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            IllegalArgumentException e = null;
            try {
                MutableBitmap wrappedBitmap = clazz.newInstance();
                IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
                IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
                integerSet.add(Integer.valueOf(Integer.MIN_VALUE));
            }
            catch (IllegalArgumentException ex) {
                e = ex;
            }
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testToArray() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            HashSet set = Sets.newHashSet((Object[])((Integer[])integerSet.toArray()));
            Assert.assertTrue((boolean)Sets.difference((Set)integerSet, (Set)set).isEmpty());
        }
    }

    @Test
    public void testToSmallArray() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            HashSet set = Sets.newHashSet((Object[])((Integer[])integerSet.toArray((Object[])new Integer[0])));
            Assert.assertTrue((boolean)Sets.difference((Set)integerSet, (Set)set).isEmpty());
        }
    }

    @Test
    public void testToBigArray() throws IllegalAccessException, InstantiationException {
        for (Class<? extends MutableBitmap> clazz : clazzes) {
            MutableBitmap wrappedBitmap = clazz.newInstance();
            IntSetTestUtility.addAllToMutable(wrappedBitmap, IntSetTestUtility.getSetBits());
            IntegerSet integerSet = IntegerSet.wrap((MutableBitmap)wrappedBitmap);
            Object[] bigArray = new Integer[1024];
            integerSet.toArray(bigArray);
            HashSet set = Sets.newHashSet((Object[])bigArray);
            Assert.assertTrue((boolean)Sets.difference((Set)integerSet, (Set)set).isEmpty());
        }
    }
}

