/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.writeout;

import io.druid.java.util.common.io.Closer;
import io.druid.segment.writeout.FileWriteOutBytes;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import io.druid.segment.writeout.WriteOutBytes;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FileUtils;

public final class TmpFileSegmentWriteOutMedium
implements SegmentWriteOutMedium {
    private final File dir;
    private final Closer closer = Closer.create();

    TmpFileSegmentWriteOutMedium(File outDir) throws IOException {
        File tmpOutputFilesDir = new File(outDir, "tmpOutputFiles");
        FileUtils.forceMkdir((File)tmpOutputFilesDir);
        this.closer.register(() -> FileUtils.deleteDirectory((File)tmpOutputFilesDir));
        this.dir = tmpOutputFilesDir;
    }

    @Override
    public WriteOutBytes makeWriteOutBytes() throws IOException {
        File file = File.createTempFile("filePeon", null, this.dir);
        FileChannel ch = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.closer.register(file::delete);
        this.closer.register((Closeable)ch);
        return new FileWriteOutBytes(file, ch);
    }

    @Override
    public Closer getCloser() {
        return this.closer;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

