/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.virtual;

import com.google.common.base.Preconditions;
import io.druid.query.dimension.DimensionSpec;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ColumnValueSelector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.ColumnCapabilities;
import javax.annotation.Nullable;

public class VirtualizedColumnSelectorFactory
implements ColumnSelectorFactory {
    private final ColumnSelectorFactory baseFactory;
    private final VirtualColumns virtualColumns;

    public VirtualizedColumnSelectorFactory(ColumnSelectorFactory baseFactory, VirtualColumns virtualColumns) {
        this.baseFactory = (ColumnSelectorFactory)Preconditions.checkNotNull((Object)baseFactory, (Object)"baseFactory");
        this.virtualColumns = (VirtualColumns)Preconditions.checkNotNull((Object)virtualColumns, (Object)"virtualColumns");
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this.baseFactory);
        }
        return this.baseFactory.makeDimensionSelector(dimensionSpec);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeColumnValueSelector(columnName);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(columnName);
        }
        return this.baseFactory.getColumnCapabilities(columnName);
    }
}

