/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.virtual;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.druid.java.util.common.ISE;
import io.druid.math.expr.Expr;
import io.druid.math.expr.Parser;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.DimensionSelectorUtils;
import io.druid.segment.IdLookup;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.SingleIndexedInt;
import io.druid.segment.virtual.SingleInputBindings;
import javax.annotation.Nullable;

public class SingleStringInputDimensionSelector
implements DimensionSelector {
    private final DimensionSelector selector;
    private final Expr expression;
    private final SingleInputBindings bindings = new SingleInputBindings();
    private final int nullAdjustment;

    public SingleStringInputDimensionSelector(DimensionSelector selector, Expr expression) {
        if (Parser.findRequiredBindings((Expr)expression).size() != 1) {
            throw new ISE("WTF?! Expected expression with just one binding", new Object[0]);
        }
        if (selector.getValueCardinality() == -1 || !selector.nameLookupPossibleInAdvance()) {
            throw new ISE("Selector of class[%s] does not have a dictionary, cannot use it.", new Object[]{selector.getClass().getName()});
        }
        this.selector = (DimensionSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
        this.expression = (Expr)Preconditions.checkNotNull((Object)expression, (Object)"expression");
        this.nullAdjustment = selector.getValueCardinality() == 0 || selector.lookupName(0) != null ? 1 : 0;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("expression", this.expression);
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts row = this.selector.getRow();
        if (row.size() == 1) {
            if (this.nullAdjustment == 0) {
                return row;
            }
            return SingleIndexedInt.of(row.get(0) + this.nullAdjustment);
        }
        return SingleIndexedInt.of(0);
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, value);
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
    }

    @Override
    public int getValueCardinality() {
        return this.selector.getValueCardinality() + this.nullAdjustment;
    }

    @Override
    public String lookupName(int id) {
        String value = id == 0 ? null : this.selector.lookupName(id - this.nullAdjustment);
        this.bindings.set(value);
        return this.expression.eval((Expr.ObjectBinding)this.bindings).asString();
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }
}

