/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.virtual;

import com.google.common.base.Predicate;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.IdLookup;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ZeroIndexedInts;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class BaseSingleValueDimensionSelector
implements DimensionSelector {
    protected abstract String getValue();

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    public String lookupName(int id) {
        return this.getValue();
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Objects.equals(BaseSingleValueDimensionSelector.this.getValue(), value);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", BaseSingleValueDimensionSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> predicate) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return predicate.apply((Object)BaseSingleValueDimensionSelector.this.getValue());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", BaseSingleValueDimensionSelector.this);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return false;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.getValue();
    }

    @Override
    public Class classOfObject() {
        return String.class;
    }
}

