/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.transform;

import io.druid.data.input.InputRow;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.segment.transform.TransformSpec;
import io.druid.segment.transform.Transformer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TransformingStringInputRowParser
extends StringInputRowParser {
    private final TransformSpec transformSpec;
    private final Transformer transformer;

    public TransformingStringInputRowParser(ParseSpec parseSpec, String encoding, TransformSpec transformSpec) {
        super(parseSpec, encoding);
        this.transformSpec = transformSpec;
        this.transformer = transformSpec.toTransformer();
    }

    public List<InputRow> parseBatch(ByteBuffer input) {
        return super.parseBatch(input).stream().map(this.transformer::transform).collect(Collectors.toList());
    }

    @Nullable
    public InputRow parse(@Nullable String input) {
        return this.transformer.transform(super.parse(input));
    }

    public StringInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new TransformingStringInputRowParser(parseSpec, this.getEncoding(), this.transformSpec);
    }

    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }
}

