/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.transform;

import io.druid.data.input.InputRow;
import io.druid.data.input.Row;
import io.druid.data.input.Rows;
import io.druid.java.util.common.DateTimes;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.groupby.RowBasedColumnSelectorFactory;
import io.druid.segment.column.ValueType;
import io.druid.segment.transform.RowFunction;
import io.druid.segment.transform.Transform;
import io.druid.segment.transform.TransformSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class Transformer {
    private final Map<String, RowFunction> transforms = new HashMap<String, RowFunction>();
    private final ThreadLocal<Row> rowSupplierForValueMatcher = new ThreadLocal();
    private final ValueMatcher valueMatcher;

    Transformer(TransformSpec transformSpec, Map<String, ValueType> rowSignature) {
        for (Transform transform : transformSpec.getTransforms()) {
            this.transforms.put(transform.getName(), transform.getRowFunction());
        }
        this.valueMatcher = transformSpec.getFilter() != null ? transformSpec.getFilter().toFilter().makeMatcher(RowBasedColumnSelectorFactory.create(this.rowSupplierForValueMatcher, rowSignature)) : null;
    }

    @Nullable
    public InputRow transform(@Nullable InputRow row) {
        if (row == null) {
            return null;
        }
        Object transformedRow = this.transforms.isEmpty() ? row : new TransformedInputRow(row, this.transforms);
        if (this.valueMatcher != null) {
            this.rowSupplierForValueMatcher.set((Row)transformedRow);
            if (!this.valueMatcher.matches()) {
                return null;
            }
        }
        return transformedRow;
    }

    public static class TransformedInputRow
    implements InputRow {
        private final InputRow row;
        private final Map<String, RowFunction> transforms;

        public TransformedInputRow(InputRow row, Map<String, RowFunction> transforms) {
            this.row = row;
            this.transforms = transforms;
        }

        public List<String> getDimensions() {
            return this.row.getDimensions();
        }

        public long getTimestampFromEpoch() {
            RowFunction transform = this.transforms.get("__time");
            if (transform != null) {
                return Rows.objectToNumber((String)"__time", (Object)transform.eval((Row)this.row)).longValue();
            }
            return this.row.getTimestampFromEpoch();
        }

        public DateTime getTimestamp() {
            RowFunction transform = this.transforms.get("__time");
            if (transform != null) {
                return DateTimes.utc((long)this.getTimestampFromEpoch());
            }
            return this.row.getTimestamp();
        }

        public List<String> getDimension(String dimension) {
            RowFunction transform = this.transforms.get(dimension);
            if (transform != null) {
                return Rows.objectToStrings((Object)transform.eval((Row)this.row));
            }
            return this.row.getDimension(dimension);
        }

        public Object getRaw(String column) {
            RowFunction transform = this.transforms.get(column);
            if (transform != null) {
                return transform.eval((Row)this.row);
            }
            return this.row.getRaw(column);
        }

        public Number getMetric(String metric) {
            RowFunction transform = this.transforms.get(metric);
            if (transform != null) {
                return Rows.objectToNumber((String)metric, (Object)transform.eval((Row)this.row));
            }
            return this.row.getMetric(metric);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformedInputRow that = (TransformedInputRow)o;
            return Objects.equals(this.row, that.row) && Objects.equals(this.transforms, that.transforms);
        }

        public int hashCode() {
            return Objects.hash(this.row, this.transforms);
        }

        public int compareTo(Row o) {
            return this.row.compareTo((Object)o);
        }
    }
}

