/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.LongColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressedColumnarLongsSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.LongGenericColumnSupplier;
import io.druid.segment.serde.Serializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LongGenericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private final Serializer serializer;

    @JsonCreator
    public static LongGenericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new LongGenericColumnPartSerde(byteOrder, null);
    }

    private LongGenericColumnPartSerde(ByteOrder byteOrder, Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                CompressedColumnarLongsSupplier column = CompressedColumnarLongsSupplier.fromByteBuffer(buffer, LongGenericColumnPartSerde.this.byteOrder);
                builder.setType(ValueType.LONG).setHasMultipleValues(false).setGenericColumn(new LongGenericColumnSupplier(column));
            }
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private LongColumnSerializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(LongColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public LongGenericColumnPartSerde build() {
            return new LongGenericColumnPartSerde(this.byteOrder, this.delegate);
        }
    }
}

