/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.FloatColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.CompressedColumnarFloatsSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.FloatGenericColumnSupplier;
import io.druid.segment.serde.Serializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class FloatGenericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private final Serializer serializer;

    @JsonCreator
    public static FloatGenericColumnPartSerde createDeserializer(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new FloatGenericColumnPartSerde(byteOrder, null);
    }

    private FloatGenericColumnPartSerde(ByteOrder byteOrder, Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                CompressedColumnarFloatsSupplier column = CompressedColumnarFloatsSupplier.fromByteBuffer(buffer, FloatGenericColumnPartSerde.this.byteOrder);
                builder.setType(ValueType.FLOAT).setHasMultipleValues(false).setGenericColumn(new FloatGenericColumnSupplier(column));
            }
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private FloatColumnSerializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(FloatColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public FloatGenericColumnPartSerde build() {
            return new FloatGenericColumnPartSerde(this.byteOrder, this.delegate);
        }
    }
}

