/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import io.druid.segment.DoubleColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.ColumnarDoubles;
import io.druid.segment.data.CompressedColumnarDoublesSuppliers;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.DoubleGenericColumnSupplier;
import io.druid.segment.serde.Serializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DoubleGenericColumnPartSerde
implements ColumnPartSerde {
    private final ByteOrder byteOrder;
    private final Serializer serializer;

    @JsonCreator
    public static DoubleGenericColumnPartSerde getDoubleGenericColumnPartSerde(@JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        return new DoubleGenericColumnPartSerde(byteOrder, null);
    }

    private DoubleGenericColumnPartSerde(ByteOrder byteOrder, Serializer serializer) {
        this.byteOrder = byteOrder;
        this.serializer = serializer;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                Supplier<ColumnarDoubles> column = CompressedColumnarDoublesSuppliers.fromByteBuffer(buffer, DoubleGenericColumnPartSerde.this.byteOrder);
                builder.setType(ValueType.DOUBLE).setHasMultipleValues(false).setGenericColumn(new DoubleGenericColumnSupplier(column));
            }
        };
    }

    public static class SerializerBuilder {
        private ByteOrder byteOrder = null;
        private DoubleColumnSerializer delegate = null;

        public SerializerBuilder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public SerializerBuilder withDelegate(DoubleColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public DoubleGenericColumnPartSerde build() {
            return new DoubleGenericColumnPartSerde(this.byteOrder, this.delegate);
        }
    }
}

