/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.google.common.base.Supplier;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.SimpleDictionaryEncodedColumn;
import io.druid.segment.data.CachingIndexed;
import io.druid.segment.data.ColumnarInts;
import io.druid.segment.data.ColumnarMultiInts;
import io.druid.segment.data.GenericIndexed;

public class DictionaryEncodedColumnSupplier
implements Supplier<DictionaryEncodedColumn> {
    private final GenericIndexed<String> dictionary;
    private final Supplier<ColumnarInts> singleValuedColumn;
    private final Supplier<ColumnarMultiInts> multiValuedColumn;
    private final int lookupCacheSize;

    public DictionaryEncodedColumnSupplier(GenericIndexed<String> dictionary, Supplier<ColumnarInts> singleValuedColumn, Supplier<ColumnarMultiInts> multiValuedColumn, int lookupCacheSize) {
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.lookupCacheSize = lookupCacheSize;
    }

    public DictionaryEncodedColumn get() {
        return new SimpleDictionaryEncodedColumn(this.singleValuedColumn != null ? (ColumnarInts)this.singleValuedColumn.get() : null, this.multiValuedColumn != null ? (ColumnarMultiInts)this.multiValuedColumn.get() : null, new CachingIndexed<String>(this.dictionary, this.lookupCacheSize));
    }
}

