/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.google.common.collect.Maps;
import io.druid.java.util.common.ISE;
import io.druid.segment.serde.ComplexMetricSerde;
import java.util.Map;

public class ComplexMetrics {
    private static final Map<String, ComplexMetricSerde> complexSerializers = Maps.newHashMap();

    public static ComplexMetricSerde getSerdeForType(String type) {
        return complexSerializers.get(type);
    }

    public static void registerSerde(String type, ComplexMetricSerde serde) {
        if (complexSerializers.containsKey(type)) {
            throw new ISE("Serializer for type[%s] already exists.", new Object[]{type});
        }
        complexSerializers.put(type, serde);
    }
}

