/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.google.common.base.Function;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexColumnSerializer;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public abstract class ComplexMetricSerde {
    public abstract String getTypeName();

    public abstract ComplexMetricExtractor getExtractor();

    public abstract void deserializeColumn(ByteBuffer var1, ColumnBuilder var2);

    @Deprecated
    public abstract ObjectStrategy getObjectStrategy();

    public Function<Object, Long> inputSizeFn() {
        return null;
    }

    public byte[] toBytes(@Nullable Object val) {
        return val != null ? this.getObjectStrategy().toBytes(val) : ByteArrays.EMPTY_ARRAY;
    }

    public Object fromBytes(byte[] data, int start, int numBytes) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        if (start > 0) {
            bb.position(start);
        }
        return this.getObjectStrategy().fromByteBuffer(bb, numBytes);
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String column) {
        return ComplexColumnSerializer.create(segmentWriteOutMedium, column, this.getObjectStrategy());
    }
}

