/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.io.smoosh.FileSmoosher;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.writeout.SegmentWriteOutMedium;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class ComplexColumnSerializer
implements GenericColumnSerializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ObjectStrategy strategy;
    private GenericIndexedWriter writer;

    public static ComplexColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy) {
        return new ComplexColumnSerializer(segmentWriteOutMedium, filenameBase, strategy);
    }

    private ComplexColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ObjectStrategy strategy) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    @Override
    public void open() throws IOException {
        this.writer = new GenericIndexedWriter(this.segmentWriteOutMedium, StringUtils.format((String)"%s.complex_column", (Object[])new Object[]{this.filenameBase}), this.strategy);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        this.writer.write(obj);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writeToVersionOne(channel);
    }

    private void writeToVersionOne(WritableByteChannel channel) throws IOException {
        this.writer.writeTo(channel, null);
    }
}

