/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import io.druid.segment.serde.Serializer;
import java.nio.ByteBuffer;

public class ComplexColumnPartSerde
implements ColumnPartSerde {
    private final String typeName;
    private final ComplexMetricSerde serde;
    private final Serializer serializer;

    private ComplexColumnPartSerde(String typeName, Serializer serializer) {
        this.typeName = typeName;
        this.serde = ComplexMetrics.getSerdeForType(typeName);
        this.serializer = serializer;
    }

    @JsonCreator
    public static ComplexColumnPartSerde createDeserializer(@JsonProperty(value="typeName") String complexType) {
        return new ComplexColumnPartSerde(complexType, null);
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    @JsonProperty
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                if (ComplexColumnPartSerde.this.serde != null) {
                    ComplexColumnPartSerde.this.serde.deserializeColumn(buffer, builder);
                }
            }
        };
    }

    public static class SerializerBuilder {
        private String typeName = null;
        private GenericColumnSerializer delegate = null;

        public SerializerBuilder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public SerializerBuilder withDelegate(GenericColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public ComplexColumnPartSerde build() {
            return new ComplexColumnPartSerde(this.typeName, this.delegate);
        }
    }
}

