/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.common.base.Preconditions;
import io.druid.segment.IndexIO;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.loading.SegmentizerFactory;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;

public class MMappedQueryableSegmentizerFactory
implements SegmentizerFactory {
    private final IndexIO indexIO;

    public MMappedQueryableSegmentizerFactory(@JacksonInject IndexIO indexIO) {
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
    }

    @Override
    public Segment factorize(DataSegment dataSegment, File parentDir) throws SegmentLoadingException {
        try {
            return new QueryableIndexSegment(dataSegment.getIdentifier(), this.indexIO.loadIndex(parentDir));
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }
}

