/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import io.druid.java.util.common.granularity.Granularity;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.BaseQuery;
import io.druid.query.QueryMetrics;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.segment.Capabilities;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.Metadata;
import io.druid.segment.StorageAdapter;
import io.druid.segment.VirtualColumns;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexColumnSelectorFactory;
import io.druid.segment.incremental.TimeAndDimsHolder;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IncrementalIndexStorageAdapter
implements StorageAdapter {
    private final IncrementalIndex<?> index;

    public IncrementalIndexStorageAdapter(IncrementalIndex<?> index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.index.getDimensionNames(), String.class);
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.index.getMetricNames();
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension.equals("__time")) {
            return Integer.MAX_VALUE;
        }
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(dimension);
        if (desc == null) {
            return 0;
        }
        DimensionIndexer indexer = this.index.getDimension(dimension).getIndexer();
        return indexer.getCardinality();
    }

    @Override
    public int getNumRows() {
        return this.index.size();
    }

    @Override
    public DateTime getMinTime() {
        return this.index.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.index.getMaxTime();
    }

    @Override
    @Nullable
    public Comparable getMinValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer indexer = desc.getIndexer();
        return indexer.getMinValue();
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String column) {
        IncrementalIndex.DimensionDesc desc = this.index.getDimension(column);
        if (desc == null) {
            return null;
        }
        DimensionIndexer indexer = desc.getIndexer();
        return indexer.getMaxValue();
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(false).build();
    }

    @Override
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.index.getCapabilities(column);
    }

    @Override
    public String getColumnTypeName(String column) {
        String metricType = this.index.getMetricType(column);
        return metricType != null ? metricType : this.getColumnCapabilities(column).getType().toString();
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.index.getMaxIngestedEventTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        if (this.index.isEmpty()) {
            return Sequences.empty();
        }
        Interval dataInterval = new Interval((ReadableInstant)this.getMinTime(), (ReadableInstant)gran.bucketEnd(this.getMaxTime()));
        if (!interval.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        Interval actualInterval = interval.overlap((ReadableInterval)dataInterval);
        Iterable iterable = gran.getIterable(actualInterval);
        if (descending) {
            iterable = Lists.reverse((List)ImmutableList.copyOf((Iterable)iterable));
        }
        return Sequences.simple((Iterable)iterable).map(i -> new IncrementalIndexCursor(virtualColumns, descending, filter, (Interval)i, actualInterval, gran));
    }

    private ValueMatcher makeFilterMatcher(Filter filter, Cursor cursor) {
        return filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(cursor.getColumnSelectorFactory());
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    private class IncrementalIndexCursor
    implements Cursor {
        private TimeAndDimsHolder currEntry = new TimeAndDimsHolder();
        private final ColumnSelectorFactory columnSelectorFactory;
        private final ValueMatcher filterMatcher;
        private final int maxRowIndex;
        private Iterator<IncrementalIndex.TimeAndDims> baseIter;
        private Iterable<IncrementalIndex.TimeAndDims> cursorIterable;
        private boolean emptyRange;
        private final DateTime time;
        private int numAdvanced;
        private boolean done;

        IncrementalIndexCursor(VirtualColumns virtualColumns, boolean descending, Filter filter, Interval interval, Interval actualInterval, Granularity gran) {
            this.columnSelectorFactory = new IncrementalIndexColumnSelectorFactory(IncrementalIndexStorageAdapter.this.index, virtualColumns, descending, this.currEntry);
            this.filterMatcher = IncrementalIndexStorageAdapter.this.makeFilterMatcher(filter, this);
            this.numAdvanced = -1;
            this.maxRowIndex = IncrementalIndexStorageAdapter.this.index.getLastRowIndex();
            long timeStart = Math.max(interval.getStartMillis(), actualInterval.getStartMillis());
            this.cursorIterable = IncrementalIndexStorageAdapter.this.index.getFacts().timeRangeIterable(descending, timeStart, Math.min(actualInterval.getEndMillis(), gran.increment(interval.getStart()).getMillis()));
            this.emptyRange = !this.cursorIterable.iterator().hasNext();
            this.time = gran.toDateTime(interval.getStartMillis());
            this.reset();
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public DateTime getTime() {
            return this.time;
        }

        @Override
        public void advance() {
            if (!this.baseIter.hasNext()) {
                this.done = true;
                return;
            }
            while (this.baseIter.hasNext()) {
                BaseQuery.checkInterrupted();
                IncrementalIndex.TimeAndDims entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) continue;
                this.currEntry.set(entry);
                if (!this.filterMatcher.matches()) continue;
                return;
            }
            this.done = true;
        }

        @Override
        public void advanceUninterruptibly() {
            if (!this.baseIter.hasNext()) {
                this.done = true;
                return;
            }
            while (this.baseIter.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                IncrementalIndex.TimeAndDims entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) continue;
                this.currEntry.set(entry);
                if (!this.filterMatcher.matches()) continue;
                return;
            }
            this.done = true;
        }

        @Override
        public void advanceTo(int offset) {
            for (int count = 0; count < offset && !this.isDone(); ++count) {
                this.advance();
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.baseIter = this.cursorIterable.iterator();
            if (this.numAdvanced == -1) {
                this.numAdvanced = 0;
            } else {
                Iterators.advance(this.baseIter, (int)this.numAdvanced);
            }
            BaseQuery.checkInterrupted();
            boolean foundMatched = false;
            while (this.baseIter.hasNext()) {
                IncrementalIndex.TimeAndDims entry = this.baseIter.next();
                if (this.beyondMaxRowIndex(entry.getRowIndex())) {
                    ++this.numAdvanced;
                    continue;
                }
                this.currEntry.set(entry);
                if (this.filterMatcher.matches()) {
                    foundMatched = true;
                    break;
                }
                ++this.numAdvanced;
            }
            this.done = !foundMatched && (this.emptyRange || !this.baseIter.hasNext());
        }

        private boolean beyondMaxRowIndex(int rowIndex) {
            return rowIndex > this.maxRowIndex;
        }
    }
}

