/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.spatial.search.Bound;
import io.druid.query.BitmapResultFactory;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.DruidDoublePredicate;
import io.druid.query.filter.DruidFloatPredicate;
import io.druid.query.filter.DruidLongPredicate;
import io.druid.query.filter.DruidPredicateFactory;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.segment.ColumnSelector;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.filter.Filters;
import io.druid.segment.incremental.SpatialDimensionRowTransformer;

public class SpatialFilter
implements Filter {
    private final String dimension;
    private final Bound bound;

    public SpatialFilter(String dimension, Bound bound) {
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        this.bound = (Bound)Preconditions.checkNotNull((Object)bound, (Object)"bound");
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        Iterable<ImmutableBitmap> search = selector.getSpatialIndex(this.dimension).search(this.bound);
        return bitmapResultFactory.unionDimensionValueBitmaps(search);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return new Predicate<String>(){

                    public boolean apply(String input) {
                        if (input == null) {
                            return false;
                        }
                        float[] coordinate = SpatialDimensionRowTransformer.decode(input);
                        return SpatialFilter.this.bound.contains(coordinate);
                    }
                };
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return DruidLongPredicate.ALWAYS_FALSE;
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return DruidFloatPredicate.ALWAYS_FALSE;
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return DruidDoublePredicate.ALWAYS_FALSE;
            }
        });
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }
}

